/*
 * Decompiled with CFR 0.152.
 */
package trackconsole.data.index.duke;

import craterstudio.math.EasyMath;
import craterstudio.verlet.Animation;
import craterstudio.verlet.VerletSpring;

public class StretchAnim
implements Animation<VerletSpring> {
    float beginLen;
    float endLen;
    float beginStf;
    float endStf;
    final float factorLen;
    final float factorStf;

    public StretchAnim() {
        this(0.75f, 2.0f);
    }

    public StretchAnim(float factorLen, float factorStf) {
        this.factorLen = factorLen;
        this.factorStf = factorStf;
    }

    @Override
    public void begin(VerletSpring spring) {
        this.beginLen = spring.len;
        this.endLen = spring.len / this.factorLen;
        this.beginStf = spring.stf;
        this.endStf = spring.stf / this.factorStf;
    }

    @Override
    public void step(VerletSpring spring, float lerp) {
        spring.len = EasyMath.lerp(lerp, this.beginLen, this.endLen);
        spring.stf = EasyMath.lerp(lerp, this.beginStf, this.endStf);
    }

    @Override
    public void end(VerletSpring spring) {
        spring.len = this.endLen;
        spring.stf = this.endStf;
    }

    @Override
    public Animation<VerletSpring> copy() {
        return new StretchAnim(this.factorLen, this.factorStf);
    }
}

