/*
 * Decompiled with CFR 0.152.
 */
package trackconsole.data.index.duke;

import craterstudio.math.Vec3;
import craterstudio.math.VecMath;
import craterstudio.verlet.VerletBody;
import craterstudio.verlet.VerletBodyActor;
import craterstudio.verlet.VerletParticle;
import craterstudio.verlet.VerletSphere;
import craterstudio.verlet.VerletSpring;

public class Rope
extends VerletBody
implements VerletBodyActor {
    private final VerletParticle p1;
    private final VerletParticle p2;

    public Rope(VerletParticle p1, VerletParticle p2, float rad, int segments, float len) {
        this.interacts = false;
        this.p1 = p1;
        this.p2 = p2;
        Vec3 v1 = new Vec3();
        Vec3 v2 = new Vec3();
        p1.getPosition(v1);
        p2.getPosition(v2);
        float stf = 1.0f;
        float wgt = 0.1f;
        VerletSphere[] spheres = new VerletSphere[segments];
        int i = 0;
        while (i < spheres.length) {
            Vec3 v = VecMath.lerp((float)i / (float)(segments - 1), v1, v2);
            spheres[i] = new VerletSphere(rad);
            spheres[i].getParticle().setPosition(v);
            spheres[i].getParticle().setWeight(wgt);
            this.addSphere(spheres[i]);
            if (i != 0) {
                this.createLocalSpring(spheres[i - 1], spheres[i], stf, 0);
            }
            ++i;
        }
        this.setLength(len);
        VerletSphere s1 = this.listSpheres().get(0);
        VerletSphere s2 = this.listSpheres().get(this.listSpheres().size() - 1);
        s1.getParticle().setInfiniteWeight();
        s2.getParticle().setInfiniteWeight();
        this.attach(this);
    }

    @Override
    public void act(VerletBody body) {
        Vec3 tmp1 = new Vec3();
        Vec3 tmp2 = new Vec3();
        VerletSphere s1 = this.listSpheres().get(0);
        VerletSphere s2 = this.listSpheres().get(this.listSpheres().size() - 1);
        this.p1.getPosition(tmp1);
        this.p2.getPosition(tmp2);
        int i = 0;
        while (i < 1) {
            s1.getParticle().setPosition(tmp1);
            s2.getParticle().setPosition(tmp2);
            for (VerletSpring spring : this.listSprings()) {
                spring.tick();
            }
            ++i;
        }
        s1.getParticle().setPosition(tmp1);
        s2.getParticle().setPosition(tmp2);
    }

    public void setLength(float len) {
        int segments = this.listSprings().size();
        for (VerletSpring spring : this.listSprings()) {
            spring.len = len / (float)segments;
        }
    }
}

