/*
 * Decompiled with CFR 0.152.
 */
package trackconsole.data.index.bulk;

import craterstudio.math.EasyMath;
import craterstudio.math.Vec3;
import craterstudio.math.VecMath;
import craterstudio.misc.ColorHSL;
import craterstudio.misc.gui.GraphicsUtil;
import craterstudio.misc.gui.UserIO;
import craterstudio.text.Text;
import craterstudio.time.Interval;
import craterstudio.util.HighLevel;
import craterstudio.verlet.AnimatingQueueVerletSpringActor;
import craterstudio.verlet.VerletBody;
import craterstudio.verlet.VerletFeedback;
import craterstudio.verlet.VerletParticle;
import craterstudio.verlet.VerletParticleActor;
import craterstudio.verlet.VerletPlane;
import craterstudio.verlet.VerletSphere;
import craterstudio.verlet.VerletSpring;
import craterstudio.verlet.VerletSpringActor;
import craterstudio.verlet.VerletWorld;
import craterstudio.verlet.liquid.VerletLiquid;
import craterstudio.verlet.liquid.VerletLiquidGrid;
import craterstudio.verlet.liquid.VerletLiquidGridFactory;
import gui.BezierCurve;
import gui.Point2f;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import trackconsole.data.ByteArray;
import trackconsole.data.index.bulk.BulkRow;
import trackconsole.data.index.duke.DelayAnim;
import trackconsole.data.index.duke.Duke;
import trackconsole.data.index.duke.Raft;
import trackconsole.data.index.duke.RetractAnim;
import trackconsole.data.index.duke.StretchAnim;

public class BulkTest {
    private static void pushLeft(Duke duke) {
        AnimatingQueueVerletSpringActor legs = new AnimatingQueueVerletSpringActor();
        legs.enqueue(new RetractAnim(0.85f, 1.0f), 500L);
        legs.enqueue(new DelayAnim(), 750L);
        legs.enqueue(new StretchAnim(0.85f, 1.0f), 500L);
        legs.enqueue(new DelayAnim(), 1500L);
        legs.enqueue(new RetractAnim(0.9f, 1.75f), 120L);
        legs.enqueue(new DelayAnim(), 50L);
        legs.enqueue(new StretchAnim(0.9f, 1.75f), 120L);
        duke.spB.attach(legs.copy());
        duke.spL.attach(legs.copy());
        duke.spR.attach(legs.copy());
        duke.spHipL.attach(legs.copy());
        duke.spHipR.attach(legs.copy());
        AnimatingQueueVerletSpringActor armL = new AnimatingQueueVerletSpringActor();
        armL.enqueue(new DelayAnim(), 500L);
        armL.enqueue(new RetractAnim(1.75f, 5.0f), 500L);
        armL.enqueue(new DelayAnim(), 250L);
        armL.enqueue(new StretchAnim(1.75f, 5.0f), 100L);
        duke.spArmL.attach(armL);
        AnimatingQueueVerletSpringActor arms = new AnimatingQueueVerletSpringActor();
        arms = new AnimatingQueueVerletSpringActor();
        arms.enqueue(new DelayAnim(), 5000L);
        arms.enqueue(new RetractAnim(1.75f, 8.0f), 1500L);
        arms.enqueue(new DelayAnim(), 250L);
        arms.enqueue(new StretchAnim(1.75f, 8.0f), 1500L);
        duke.spArmL.attach(arms.copy());
        duke.spArmR.attach(arms.copy());
    }

    public static void main(String[] args) throws IOException {
        int waterCount = 8192;
        final Duke duke = new Duke();
        duke.translate(900.0f, 1300.0f, 0.0f);
        final Raft raft = new Raft(15, 12.5f);
        raft.translate(200.0f, 2250.0f, 0.0f);
        for (VerletSphere s : raft.listSpheres()) {
            s.p.setWeight(1.25f);
            s.setFriction(0.9f);
        }
        for (VerletSphere s : duke.listSpheres()) {
            s.p.setWeight(1.0f);
            s.setFriction(0.9f);
        }
        raft.listSpheres().get(0).getParticle();
        final VerletParticle p1 = new VerletParticle();
        p1.setPosition(600.0f, 700.0f, 0.0f);
        p1.setInfiniteWeight();
        duke.setDrag(0.01f);
        raft.setDrag(0.01f);
        AnimatingQueueVerletSpringActor breathing = new AnimatingQueueVerletSpringActor();
        breathing.enqueue(new RetractAnim(1.25f, 1.25f), 1750L);
        breathing.enqueue(new DelayAnim(), 500L);
        breathing.enqueue(new StretchAnim(1.25f, 1.25f), 1750L);
        breathing.enqueue(new DelayAnim(), 500L);
        breathing.loop();
        duke.spShoulder.attach(breathing);
        final VerletWorld world = new VerletWorld();
        world.setGravity(0.0f, -0.02f, 0.0f);
        world.addPlane(VerletPlane.infer(new Vec3(0.0f, 0.0f, 0.0f), new Vec3(0.0f, 1.0f, 0.0f)));
        world.addPlane(VerletPlane.infer(new Vec3(0.0f, 0.0f, 0.0f), new Vec3(1.0f, 0.0f, 0.0f)));
        world.addPlane(VerletPlane.infer(new Vec3(1280.0f, 0.0f, 0.0f), new Vec3(0.0f, 0.0f, 0.0f)));
        Random r = new Random();
        VerletLiquidGrid grid = VerletLiquidGridFactory.createGridForXY(-100.0f, 1380.0f, -100.0f, 2100.0f);
        final VerletLiquid water = new VerletLiquid(3.75f, 0.25f, 0.033f, grid);
        int i = 0;
        while (i < waterCount) {
            water.addDrop(r.nextFloat() * 1280.0f, 750.0f + r.nextFloat() * 1000.0f, 0.0f);
            ++i;
        }
        water.interact(raft);
        world.addBody(water);
        world.addBody(raft);
        duke.pTop.attach(new VerletParticleActor(){

            @Override
            public void act(VerletParticle particle) {
                particle.addForce(0.0f, 0.05f, 0.0f);
            }
        });
        duke.spL.attach(new VerletSpringActor(){
            long since = Long.MAX_VALUE;

            @Override
            public void act(VerletSpring spring) {
                Vec3 v1 = new Vec3();
                Vec3 v2 = new Vec3();
                spring.a.getPosition(v1);
                spring.b.getPosition(v2);
                v1.z = v1.y;
                v2.z = v2.y;
                v1.y = 0.0f;
                v2.y = 0.0f;
                float angle = VecMath.angleToFlat3D(v1, v2);
                if (EasyMath.isBetween(angle *= -1.0f, -15.0f, 15.0f)) {
                    long elapsed;
                    if (this.since == Long.MAX_VALUE) {
                        this.since = System.currentTimeMillis();
                    }
                    if ((elapsed = System.currentTimeMillis() - this.since) > 2500L) {
                        System.out.println("kick! => " + angle);
                        BulkTest.pushLeft(duke);
                        this.since = System.currentTimeMillis();
                    }
                } else {
                    this.since = Long.MAX_VALUE;
                }
            }
        });
        final VerletFeedback feedback = new VerletFeedback(){

            @Override
            public void collision(VerletBody bodyOfSphere, VerletSphere sphere, VerletPlane plane, float depth) {
                sphere.getParticle().mulVelocity(sphere.invFriction);
            }

            @Override
            public void collision(VerletBody bodyOfSphere1, VerletSphere sphere1, VerletBody bodyOfSphere2, VerletSphere sphere2, float depth) {
                float invFrict = sphere1.invFriction * sphere2.invFriction;
                Vec3 v1 = new Vec3();
                Vec3 v2 = new Vec3();
                sphere1.getParticle().getVelocity(v1);
                sphere2.getParticle().getVelocity(v2);
                Vec3 vd = new Vec3();
                vd.load(v2).sub(v1).mul(invFrict);
                if (bodyOfSphere1 == duke && bodyOfSphere2 == raft) {
                    duke.addForce(vd.x, vd.y, vd.z);
                    invFrict = 1.0f;
                }
                if (bodyOfSphere1 == raft && bodyOfSphere2 == duke) {
                    duke.addForce(-vd.x, -vd.y, -vd.z);
                    invFrict = 1.0f;
                }
                sphere1.getParticle().mulVelocity(invFrict);
                sphere2.getParticle().mulVelocity(invFrict);
            }

            @Override
            public void springUpdate(VerletBody bodyOfSring, VerletSpring spring, float tension) {
            }
        };
        final boolean[] pressed = new boolean[1];
        final JPanel canvas = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Vec3 temp = new Vec3();
                g.setColor(Color.LIGHT_GRAY);
                for (VerletBody body : world.listBodies()) {
                    body.boundingSphere.p.getPosition(temp);
                    this.drawSphere(g, temp, body.boundingSphere.radius);
                }
                Color[] cols = new Color[]{ColorHSL.toColor(0.6f, 0.575f, 0.775f), ColorHSL.toColor(0.6f, 0.6f, 0.8f), ColorHSL.toColor(0.6f, 0.625f, 0.783f), ColorHSL.toColor(0.6f, 0.65f, 0.812f)};
                int c = 0;
                List<VerletSphere> ss = water.listSpheres();
                for (VerletSphere s : ss) {
                    g.setColor(cols[c++ % cols.length]);
                    s.p.getPosition(temp);
                    this.fillBox(g, temp, s.radius * 1.25f);
                }
                GraphicsUtil.enableAA(g);
                g.setColor(Color.BLACK);
                if (pressed[0]) {
                    g.setColor(Color.RED);
                    for (VerletSpring spring : duke.listSprings()) {
                        VerletParticle p1 = spring.a;
                        VerletParticle p2 = spring.b;
                        Vec3 v1 = new Vec3();
                        Vec3 v2 = new Vec3();
                        p1.getPosition(v1);
                        p2.getPosition(v2);
                        v1.y = (float)this.getHeight() - v1.y;
                        v2.y = (float)this.getHeight() - v2.y;
                        this.drawLine(g, v1, v2);
                    }
                }
                this.simpleRenderBody(g, raft, null, Color.GREEN);
            }

            private void simpleRenderBody(Graphics g, VerletBody body, Color springs, Color spheres) {
                Vec3 v1 = new Vec3();
                Vec3 v2 = new Vec3();
                Vec3 temp = new Vec3();
                if (springs != null) {
                    g.setColor(springs);
                    for (VerletSpring spring : body.listSprings()) {
                        VerletParticle p1 = spring.a;
                        VerletParticle p2 = spring.b;
                        p1.getPosition(v1);
                        p2.getPosition(v2);
                        v1.y = (float)this.getHeight() - v1.y;
                        v2.y = (float)this.getHeight() - v2.y;
                        this.drawLine(g, v1, v2);
                    }
                }
                if (spheres != null) {
                    g.setColor(spheres);
                    for (VerletSphere s : body.listSpheres()) {
                        s.p.getPosition(temp);
                        this.drawSphere(g, temp, s.radius);
                    }
                }
            }

            private void curve(Graphics g, List<Point2f> ps, int segments, float trim) {
                Point2f[] pa = ps.toArray(new Point2f[ps.size()]);
                Point2f last = null;
                int i = 0;
                while (i < segments) {
                    float t = (float)i / (float)(segments - 1);
                    t *= 1.0f - 2.0f * trim;
                    Point2f curr = BezierCurve.interpolate(t += trim, pa);
                    if (last != null) {
                        g.drawLine((int)last.x, (int)last.y, (int)curr.x, (int)curr.y);
                    }
                    last = curr;
                    ++i;
                }
            }

            private void fillCurve(Point2f[] psa, int segments, float trim, Polygon p) {
                int i = 0;
                while (i < segments) {
                    float t = (float)i / (float)(segments - 1);
                    t *= 1.0f - 2.0f * trim;
                    Point2f q = BezierCurve.interpolate(t += trim, psa);
                    p.addPoint(Math.round(q.x), Math.round(q.y));
                    ++i;
                }
            }

            private Point2f toPoint(VerletParticle p) {
                float x = p.now.x;
                float y = p.now.y;
                y = (float)this.getHeight() - y;
                return new Point2f(x, y);
            }

            private void drawLine(Graphics g, Vec3 a, Vec3 b) {
                int x1 = (int)a.x;
                int y1 = (int)a.y;
                int x2 = (int)b.x;
                int y2 = (int)b.y;
                g.drawLine(x1, y1, x2, y2);
            }

            private void drawSphere(Graphics g, Vec3 p, float r) {
                int x = Math.round(p.x);
                int y = Math.round((float)this.getHeight() - p.y);
                int ir = Math.round(r);
                int d = Math.round(r * 2.0f);
                g.drawOval(x - ir, y - ir, d, d);
            }

            private void fillSphere(Graphics g, Vec3 p, float r) {
                int x = Math.round(p.x);
                int y = Math.round((float)this.getHeight() - p.y);
                int ir = Math.round(r);
                int d = Math.round(r * 2.0f);
                g.fillOval(x - ir, y - ir, d, d);
            }

            private void drawBox(Graphics g, Vec3 p, float r) {
                int x = Math.round(p.x);
                int y = Math.round((float)this.getHeight() - p.y);
                int ir = Math.round(r);
                int d = Math.round(r * 2.0f);
                g.drawRect(x - ir, y - ir, d, d);
            }

            private void fillBox(Graphics g, Vec3 p, float r) {
                int x = Math.round(p.x);
                int y = Math.round((float)this.getHeight() - p.y);
                int ir = Math.round(r);
                int d = Math.round(r * 2.0f);
                g.fillRect(x - ir, y - ir, d, d);
            }
        };
        canvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                pressed[0] = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                pressed[0] = false;
            }
        });
        canvas.setPreferredSize(new Dimension(1024, 768));
        UserIO.setSystemLookAndFeel();
        final JFrame frame = UserIO.createDefaultHolder(canvas);
        final Point p = new Point();
        canvas.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                p.setLocation(e.getPoint());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                p.setLocation(e.getPoint());
            }
        });
        new Thread(){

            @Override
            public void run() {
                Interval fps = new Interval(1000L);
                int frameCount = 0;
                while (true) {
                    if (fps.hasPassed()) {
                        frame.setTitle("FPS: " + frameCount);
                        frameCount = 0;
                    }
                    ++frameCount;
                    HighLevel.sleep(1L);
                    Vec3 at = new Vec3(p.x, p.y, 0.0f);
                    at.y = (float)canvas.getHeight() - at.y;
                    p1.setPosition(at.x, at.y, 0.0f);
                    p1.setVelocity(0.0f, 0.0f, 0.0f);
                    if (pressed[0]) {
                        Vec3 vRaft = raft.listSpheres().get((int)0).p.now;
                        Vec3 pp = new Vec3(vRaft.x, vRaft.y, 0.0f);
                        at.sub(pp).normalize().mul(0.5f, 0.75f, 0.5f).mul(10.5f);
                        raft.listSpheres().get((int)0).p.addForce(at);
                    }
                    System.nanoTime();
                    world.step(feedback);
                    System.nanoTime();
                    canvas.repaint();
                }
            }
        }.start();
    }

    private static List<BulkRow> generateRandomBulkRows(Random r, int rowCount, int keySize, int valSize) {
        ArrayList<BulkRow> list = new ArrayList<BulkRow>();
        HashSet<ByteArray> keys = new HashSet<ByteArray>();
        char[] chars = "0123456789".toCharArray();
        int i = 0;
        while (i < rowCount) {
            byte[] key;
            while (!keys.add(new ByteArray(key = Text.ascii(Text.generateRandomCode(keySize, chars, r))))) {
            }
            byte[] val = Text.ascii(Text.generateRandomCode(valSize, chars, r));
            list.add(new BulkRow(key, val));
            ++i;
        }
        return list;
    }
}

