/*
 * Decompiled with CFR 0.152.
 */
package trackconsole.data.index.bulk;

import craterstudio.text.Text;
import craterstudio.util.DuoOperator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import trackconsole.data.ByteArray;
import trackconsole.data.index.bulk.BulkResult;
import trackconsole.data.index.bulk.BulkRow;

public class BulkKeyValue {
    final RandomAccessFile raf;
    final File dump;
    final int keySize;
    final int valSize;
    final int padSize;
    final int keyOffset;
    final int valOffset;

    public BulkKeyValue(File file, File dump, int keySize, int valSize) throws IOException {
        this(file, dump, keySize, valSize, 0);
    }

    public BulkKeyValue(File file, File dump, int keySize, int valSize, int padSize) throws IOException {
        this.raf = new RandomAccessFile(file, "rw");
        this.raf.getChannel().lock();
        this.dump = dump;
        this.keySize = keySize;
        this.valSize = valSize;
        this.padSize = padSize;
        this.keyOffset = 0;
        this.valOffset = this.keyOffset + this.keySize;
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public void putBulk(List<BulkRow> rows, int chunkSize, final int batchSize) throws IOException {
        int read;
        final RandomAccessFile dumpRaf = new RandomAccessFile(this.dump, "rw");
        dumpRaf.getChannel().lock();
        final ArrayList pending = new ArrayList();
        final Runnable store = new Runnable(){

            @Override
            public void run() {
                int stride = BulkKeyValue.this.stride();
                byte[] data = new byte[pending.size() * stride];
                int offset = 0;
                for (BulkRow bulkRow : pending) {
                    byte[] key = bulkRow.key();
                    byte[] val = bulkRow.val();
                    System.arraycopy(key, 0, data, offset + BulkKeyValue.this.keyOffset, key.length);
                    System.arraycopy(val, 0, data, offset + BulkKeyValue.this.valOffset, val.length);
                    offset += stride;
                }
                try {
                    dumpRaf.write(data);
                }
                catch (IOException exc) {
                    throw new IllegalStateException(exc);
                }
                pending.clear();
            }
        };
        BulkResult result = new BulkResult(){

            @Override
            public void provide(byte[] key, byte[] val) {
                pending.add(new BulkRow(key, val));
                if (pending.size() == batchSize) {
                    store.run();
                }
            }
        };
        this.putBulkImpl(rows, chunkSize, result);
        if (!pending.isEmpty()) {
            store.run();
        }
        this.raf.seek(0L);
        this.raf.setLength(dumpRaf.length());
        dumpRaf.seek(0L);
        byte[] buffer = new byte[65536];
        while ((read = dumpRaf.read(buffer)) != -1) {
            this.raf.write(buffer, 0, read);
        }
        this.raf.getFD().sync();
        dumpRaf.close();
        if (!this.dump.delete()) {
            throw new IllegalStateException("failed to delete dump file");
        }
    }

    private void putBulkImpl(List<BulkRow> rows, int chunkSize, final BulkResult result) throws IOException {
        this.checkKeyValSize(rows);
        this.sortRowsByKey(rows);
        this.checkUniqueRowKeys(rows);
        final Iterator<BulkRow> source = rows.iterator();
        final BulkRow[] currentFindRow = new BulkRow[1];
        DuoOperator<byte[]> operator = new DuoOperator<byte[]>(){

            public void operate(byte[] key, byte[] val) {
                block5: {
                    while (true) {
                        int cmp;
                        if (currentFindRow[0] == null) {
                            if (!source.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            currentFindRow[0] = (BulkRow)((Object)source.next());
                            if (currentFindRow[0] == null) {
                                throw new NullPointerException();
                            }
                        }
                        if ((cmp = ByteArray.compareTo((byte[])currentFindRow[0].key(), (byte[])key)) == 0) {
                            result.provide(key, currentFindRow[0].val());
                            currentFindRow[0] = null;
                            break block5;
                        }
                        if (cmp >= 0) break;
                        result.provide(currentFindRow[0].key(), currentFindRow[0].val());
                        currentFindRow[0] = null;
                    }
                    result.provide(key, val);
                }
            }
        };
        try {
            this.iterate(chunkSize, operator);
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (currentFindRow[0] != null) {
            result.provide(currentFindRow[0].key(), currentFindRow[0].val());
        }
        while (source.hasNext()) {
            BulkRow row = source.next();
            result.provide(row.key(), row.val());
        }
    }

    public void getBulk(List<byte[]> keys, int chunkSize, boolean returnNull, final BulkResult result) throws IOException {
        this.checkKeySize(keys);
        this.sortKeys(keys);
        this.checkUniqueKeys(keys);
        final Iterator<byte[]> source = keys.iterator();
        final byte[][] currentFindKey = new byte[1][];
        DuoOperator<byte[]> operator = new DuoOperator<byte[]>(){

            public void operate(byte[] key, byte[] val) {
                int cmp;
                do {
                    if (currentFindKey[0] == null) {
                        if (!source.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        currentFindKey[0] = (byte[])source.next();
                        if (currentFindKey[0] == null) {
                            throw new NullPointerException();
                        }
                    }
                    if ((cmp = ByteArray.compareTo((byte[])currentFindKey[0], (byte[])key)) != 0) continue;
                    result.provide(currentFindKey[0], val);
                    currentFindKey[0] = null;
                    break;
                } while (cmp < 0);
            }
        };
        try {
            this.iterate(chunkSize, operator);
        }
        catch (NoSuchElementException exc) {
            System.err.println(exc);
        }
        if (returnNull) {
            if (currentFindKey[0] != null) {
                result.provide(currentFindKey[0], null);
            }
            while (source.hasNext()) {
                result.provide(source.next(), null);
            }
        }
    }

    private void sortKeys(List<byte[]> keys) {
        Collections.sort(keys, new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return ByteArray.compareTo((byte[])o1, (byte[])o2);
            }
        });
    }

    private void checkUniqueKeys(List<byte[]> sortedKeys) {
        byte[] lastKey = null;
        for (byte[] key : sortedKeys) {
            if (lastKey == null) {
                lastKey = key;
                continue;
            }
            if (Arrays.equals(lastKey, key)) {
                throw new IllegalStateException("getBulk[pre-condition] :: duplicate key: " + Text.ascii(key));
            }
            lastKey = key;
        }
    }

    private void checkKeySize(List<byte[]> keys) {
        for (byte[] key : keys) {
            if (key.length == this.keySize) continue;
            throw new IllegalStateException("getBulk[pre-condition] row[n].key.length incorrect");
        }
    }

    private void checkKeyValSize(List<BulkRow> rows) {
        for (BulkRow row : rows) {
            if (row.key().length != this.keySize) {
                throw new IllegalStateException("putBulk[pre-condition] row[n].key.length incorrect");
            }
            if (row.val().length == this.valSize) continue;
            throw new IllegalStateException("putBulk[pre-condition] row[n].val.length incorrect");
        }
    }

    private void sortRowsByKey(List<BulkRow> rows) {
        Collections.sort(rows, new Comparator<BulkRow>(){

            @Override
            public int compare(BulkRow o1, BulkRow o2) {
                return ByteArray.compareTo((byte[])o1.key(), (byte[])o2.key());
            }
        });
    }

    private void checkUniqueRowKeys(List<BulkRow> sortedRows) {
        byte[] lastKey = null;
        for (BulkRow row : sortedRows) {
            if (lastKey == null) {
                lastKey = row.key();
                continue;
            }
            if (Arrays.equals(lastKey, row.key())) {
                throw new IllegalStateException("putBulk[pre-condition] :: duplicate key: " + Text.ascii(row.key()));
            }
            lastKey = row.key();
        }
    }

    public int rows() throws IOException {
        long len = this.raf.length();
        if (len % (long)this.stride() != 0L) {
            throw new IllegalStateException();
        }
        return (int)(len / (long)this.stride());
    }

    int stride() {
        return this.keySize + this.valSize + this.padSize;
    }

    public void iterate(int chunkSize, DuoOperator<byte[]> operator) throws IOException {
        if (chunkSize < this.stride()) {
            throw new IllegalStateException();
        }
        chunkSize /= this.stride();
        byte[] chunk = new byte[chunkSize *= this.stride()];
        int rows = this.rows();
        int chunkRows = chunkSize / this.stride();
        int chunkCount = rows / chunkRows;
        int counter = 0;
        this.raf.seek(0L);
        int k = 0;
        while (k < chunkCount) {
            this.raf.readFully(chunk);
            int i = 0;
            while (i < chunkRows) {
                byte[] key = new byte[this.keySize];
                byte[] val = new byte[this.valSize];
                System.arraycopy(chunk, i * this.stride() + this.keyOffset, key, 0, key.length);
                System.arraycopy(chunk, i * this.stride() + this.valOffset, val, 0, val.length);
                operator.operate((Object)key, (Object)val);
                ++counter;
                ++i;
            }
            ++k;
        }
        if ((chunkRows = rows - chunkCount * chunkRows) == 0) {
            if (counter != rows) {
                throw new IllegalStateException();
            }
            return;
        }
        this.raf.readFully(chunk, 0, chunkRows * this.stride());
        int i = 0;
        while (i < chunkRows) {
            byte[] key = new byte[this.keySize];
            byte[] val = new byte[this.valSize];
            System.arraycopy(chunk, i * this.stride() + this.keyOffset, key, 0, key.length);
            System.arraycopy(chunk, i * this.stride() + this.valOffset, val, 0, val.length);
            operator.operate((Object)key, (Object)val);
            ++counter;
            ++i;
        }
        if (counter != rows) {
            throw new IllegalStateException();
        }
    }
}

