/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Point2f;

public class BezierCurve {
    public static Point2f interpolate4(float t, Point2f p1, Point2f p2, Point2f p3, Point2f p4) {
        float m1 = BezierCurve.pow(1.0f - t, 3) * 1.0f * BezierCurve.pow(t, 0);
        float m2 = BezierCurve.pow(1.0f - t, 2) * 3.0f * BezierCurve.pow(t, 1);
        float m3 = BezierCurve.pow(1.0f - t, 1) * 3.0f * BezierCurve.pow(t, 2);
        float m4 = BezierCurve.pow(1.0f - t, 0) * 1.0f * BezierCurve.pow(t, 3);
        float x = 0.0f;
        float y = 0.0f;
        x += p1.x * m1;
        y += p1.y * m1;
        x += p2.x * m2;
        y += p2.y * m2;
        x += p3.x * m3;
        y += p3.y * m3;
        return new Point2f(x += p4.x * m4, y += p4.y * m4);
    }

    private static float pow(float t, int times) {
        float tt = 1.0f;
        int i = 0;
        while (i < times) {
            tt *= t;
            ++i;
        }
        return tt;
    }

    public static Point2f interpolate(float t, Point2f ... ps) {
        float x = 0.0f;
        float y = 0.0f;
        int n = ps.length - 1;
        int k = 0;
        while (k <= n) {
            float m = BezierCurve.pow(1.0f - t, n - k) * BezierCurve.coeff(n, k) * BezierCurve.pow(t, k);
            x += ps[k].x * m;
            y += ps[k].y * m;
            ++k;
        }
        return new Point2f(x, y);
    }

    private static float coeff(int n, int k) {
        return (float)(BezierCurve.fact(n) / (BezierCurve.fact(k) * BezierCurve.fact(n - k)));
    }

    private static double fact(int n) {
        double val = 1.0;
        int i = 2;
        while (i <= n) {
            val *= (double)i;
            ++i;
        }
        return val;
    }
}

