/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet.liquid;

import craterstudio.util.Bag;
import craterstudio.util.concur.RunnableQueue;
import craterstudio.verlet.VerletSphere;
import craterstudio.verlet.liquid.VerletLiquid;
import craterstudio.verlet.liquid.VerletLiquidGrid;
import craterstudio.verlet.liquid.VerletLiquidVisitor;

public class VerletLiquidWorker {
    private final RunnableQueue[] queues;

    public VerletLiquidWorker() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public VerletLiquidWorker(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException();
        }
        if (threads == 1) {
            threads = 0;
        }
        this.queues = new RunnableQueue[threads];
        int i = 0;
        while (i < this.queues.length) {
            this.queues[i] = new RunnableQueue();
            this.queues[i].launch();
            ++i;
        }
    }

    public void collide(VerletLiquid liquid, VerletLiquidGrid grid) {
        final VerletLiquidVisitor visitor = liquid.createVisitor();
        if (this.queues.length == 0) {
            grid.visit(visitor);
            return;
        }
        grid.visit(new VerletLiquidVisitor(){

            @Override
            public void visit(final int x, final int y, final int z, final Bag<VerletSphere> local, final Bag<VerletSphere> surround) {
                int grouping = 5;
                int thread = x / grouping % VerletLiquidWorker.this.queues.length;
                VerletLiquidWorker.this.queues[thread].later(new Runnable(){

                    @Override
                    public void run() {
                        visitor.visit(x, y, z, local, surround);
                    }
                });
            }
        });
        int i = 0;
        while (i < this.queues.length) {
            this.queues[i].getBarrier().yieldFor();
            ++i;
        }
    }
}

