/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet.liquid;

import craterstudio.math.EasyMath;
import craterstudio.math.Vec3;
import craterstudio.util.Bag;
import craterstudio.verlet.VerletSphere;
import craterstudio.verlet.liquid.VerletLiquidGrid;
import craterstudio.verlet.liquid.VerletLiquidVisitor;

public class VerletLiquidGridXZ
implements VerletLiquidGrid {
    private final float xMin;
    private final float xMax;
    private final float zMin;
    private final float zMax;
    final float size;
    private final int w;
    private final int d;
    private final Bag<VerletSphere>[][] cells;
    private final Bag<VerletSphere>[][] filled;
    final Bag<VerletSphere> outer;

    VerletLiquidGridXZ(float xMin, float xMax, float zMin, float zMax, float size) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.zMin = zMin;
        this.zMax = zMax;
        this.size = size;
        this.w = (int)Math.ceil((xMax - xMin) / size);
        this.d = (int)Math.ceil((zMax - zMin) / size);
        this.cells = new Bag[this.w][this.d];
        this.filled = new Bag[this.w][this.d];
        int z = 0;
        while (z < this.d) {
            int x = 0;
            while (x < this.w) {
                this.cells[x][z] = new Bag();
                this.filled[x][z] = new Bag();
                ++x;
            }
            ++z;
        }
        this.outer = new Bag();
    }

    @Override
    public float getCellSize() {
        return this.size;
    }

    @Override
    public Bag<VerletSphere> getOuterSpheres() {
        return this.outer;
    }

    @Override
    public VerletLiquidGridXZ copy(float size) {
        return new VerletLiquidGridXZ(this.xMin, this.xMax, this.zMin, this.zMax, size);
    }

    public void shrink() {
        int z = 0;
        while (z < this.d) {
            int x = 0;
            while (x < this.w) {
                this.cells[x][z].shrink();
                ++x;
            }
            ++z;
        }
        this.outer.shrink();
    }

    @Override
    public void clear() {
        int z = 0;
        while (z < this.d) {
            int x = 0;
            while (x < this.w) {
                this.cells[x][z].clear();
                ++x;
            }
            ++z;
        }
        this.outer.clear();
    }

    @Override
    public void put(VerletSphere sphere) {
        this.lookupCell(sphere.p.now).put(sphere);
    }

    @Override
    public void queryBoundingBox(VerletSphere bounds, Bag<VerletSphere> fill) {
        Vec3 center = bounds.p.now;
        Vec3 min = new Vec3(center).sub(bounds.radius);
        Vec3 max = new Vec3(center).add(bounds.radius);
        int neighbours = 1;
        int x1 = Math.round(EasyMath.invLerp(min.x, this.xMin, this.xMax) * (float)this.w) - neighbours;
        int x2 = Math.round(EasyMath.invLerp(max.x, this.xMin, this.xMax) * (float)this.w) + neighbours;
        int z1 = Math.round(EasyMath.invLerp(min.y, this.zMin, this.zMax) * (float)this.d) - neighbours;
        int z2 = Math.round(EasyMath.invLerp(max.y, this.zMin, this.zMax) * (float)this.d) + neighbours;
        this.fillFor(x1, x2, z1, z2, fill);
    }

    @Override
    public void visit(VerletLiquidVisitor visitor) {
        int z = 0;
        while (z < this.d) {
            int x = 0;
            while (x < this.w) {
                if (this.cells[x][z].size() != 0) {
                    visitor.visit(x, 0, z, this.cells[x][z], this.filled[x][z]);
                }
                ++x;
            }
            ++z;
        }
    }

    @Override
    public int outerCount() {
        return this.outer.size();
    }

    @Override
    public void tick() {
        int z = 0;
        while (z < this.d) {
            int x = 0;
            while (x < this.w) {
                this.filled[x][z].shrink();
                this.filled[x][z].clear();
                this.fillFor(x - 1, x + 1, z - 1, z + 1, this.filled[x][z]);
                ++x;
            }
            ++z;
        }
    }

    private void fillFor(int x1, int x2, int z1, int z2, Bag<VerletSphere> fill) {
        boolean putOuter = false;
        int iz = z1;
        while (iz <= z2) {
            int ix = x1;
            while (ix <= x2) {
                if ((ix | iz) < 0 || ix >= this.w || iz >= this.d) {
                    putOuter = true;
                } else {
                    fill.putAll(this.cells[ix][iz]);
                }
                ++ix;
            }
            ++iz;
        }
        if (putOuter) {
            fill.putAll(this.outer);
        }
    }

    private Bag<VerletSphere> lookupCell(Vec3 v) {
        return this.lookupCell(v.x, v.z);
    }

    private Bag<VerletSphere> lookupCell(float x, float z) {
        int iz;
        int ix = Math.round(EasyMath.invLerp(x, this.xMin, this.xMax) * (float)this.w);
        if ((ix | (iz = Math.round(EasyMath.invLerp(z, this.zMin, this.zMax) * (float)this.d))) < 0 || ix >= this.w || iz >= this.d) {
            return this.outer;
        }
        return this.cells[ix][iz];
    }
}

