/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet.liquid;

import craterstudio.math.EasyMath;
import craterstudio.math.Vec3;
import craterstudio.util.Bag;
import craterstudio.verlet.VerletSphere;
import craterstudio.verlet.liquid.VerletLiquidGrid;
import craterstudio.verlet.liquid.VerletLiquidVisitor;

public class VerletLiquidGridXYZ
implements VerletLiquidGrid {
    private final float xMin;
    private final float xMax;
    private final float yMin;
    private final float yMax;
    private final float zMin;
    private final float zMax;
    final float size;
    private final int w;
    private final int h;
    private final int d;
    private final Bag<VerletSphere>[][][] cells;
    private final Bag<VerletSphere>[][][] filled;
    final Bag<VerletSphere> outer;

    VerletLiquidGridXYZ(float xMin, float xMax, float yMin, float yMax, float zMin, float zMax, float size) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.zMin = zMin;
        this.zMax = zMax;
        this.size = size;
        this.w = (int)Math.ceil((xMax - xMin) / size);
        this.h = (int)Math.ceil((yMax - yMin) / size);
        this.d = (int)Math.ceil((zMax - zMin) / size);
        this.cells = new Bag[this.w][this.h][this.d];
        this.filled = new Bag[this.w][this.h][this.d];
        int z = 0;
        while (z < this.d) {
            int y = 0;
            while (y < this.h) {
                int x = 0;
                while (x < this.w) {
                    this.cells[x][y][z] = new Bag();
                    this.filled[x][y][z] = new Bag();
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        this.outer = new Bag();
    }

    @Override
    public float getCellSize() {
        return this.size;
    }

    @Override
    public Bag<VerletSphere> getOuterSpheres() {
        return this.outer;
    }

    @Override
    public VerletLiquidGridXYZ copy(float size) {
        return new VerletLiquidGridXYZ(this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, size);
    }

    @Override
    public void clear() {
        int z = 0;
        while (z < this.d) {
            int y = 0;
            while (y < this.h) {
                int x = 0;
                while (x < this.w) {
                    this.cells[x][y][z].clear();
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        this.outer.clear();
    }

    @Override
    public void put(VerletSphere sphere) {
        this.lookupCell(sphere.p.now).put(sphere);
    }

    @Override
    public void queryBoundingBox(VerletSphere bounds, Bag<VerletSphere> fill) {
        Vec3 center = bounds.p.now;
        Vec3 min = new Vec3(center).sub(bounds.radius);
        Vec3 max = new Vec3(center).add(bounds.radius);
        int neighbours = 1;
        int x1 = Math.round(EasyMath.invLerp(min.x, this.xMin, this.xMax) * (float)this.w) - neighbours;
        int x2 = Math.round(EasyMath.invLerp(max.x, this.xMin, this.xMax) * (float)this.w) + neighbours;
        int y1 = Math.round(EasyMath.invLerp(min.y, this.yMin, this.yMax) * (float)this.h) - neighbours;
        int y2 = Math.round(EasyMath.invLerp(max.y, this.yMin, this.yMax) * (float)this.h) + neighbours;
        int z1 = Math.round(EasyMath.invLerp(min.z, this.zMin, this.zMax) * (float)this.d) - neighbours;
        int z2 = Math.round(EasyMath.invLerp(max.z, this.zMin, this.zMax) * (float)this.d) + neighbours;
        this.fillFor(x1, x2, y1, y2, z1, z2, fill);
    }

    @Override
    public void visit(VerletLiquidVisitor visitor) {
        int z = 0;
        while (z < this.d) {
            int y = 0;
            while (y < this.h) {
                int x = 0;
                while (x < this.w) {
                    if (this.cells[x][y][z].size() != 0) {
                        visitor.visit(x, y, z, this.cells[x][y][z], this.filled[x][y][z]);
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    @Override
    public int outerCount() {
        return this.outer.size();
    }

    @Override
    public void tick() {
        int z = 0;
        while (z < this.d) {
            int x = 0;
            while (x < this.w) {
                int y = 0;
                while (y < this.h) {
                    this.filled[x][y][z].shrink();
                    this.filled[x][y][z].clear();
                    this.fillFor(x - 1, x + 1, y - 1, y + 1, z - 1, z + 1, this.filled[x][y][z]);
                    ++y;
                }
                ++x;
            }
            ++z;
        }
    }

    private void fillFor(int x1, int x2, int y1, int y2, int z1, int z2, Bag<VerletSphere> fill) {
        boolean putOuter = false;
        int iz = z1;
        while (iz <= z2) {
            int iy = y1;
            while (iy <= y2) {
                int ix = x1;
                while (ix <= x2) {
                    if ((ix | iy | iz) < 0 || ix >= this.w || iy >= this.h || iz >= this.d) {
                        putOuter = true;
                    } else {
                        fill.putAll(this.cells[ix][iy][iz]);
                    }
                    ++ix;
                }
                ++iy;
            }
            ++iz;
        }
        if (putOuter) {
            fill.putAll(this.outer);
        }
    }

    private Bag<VerletSphere> lookupCell(Vec3 v) {
        return this.lookupCell(v.x, v.y, v.z);
    }

    private Bag<VerletSphere> lookupCell(float x, float y, float z) {
        int iz;
        int iy;
        int ix = Math.round(EasyMath.invLerp(x, this.xMin, this.xMax) * (float)this.w);
        if ((ix | (iy = Math.round(EasyMath.invLerp(y, this.yMin, this.yMax) * (float)this.h)) | (iz = Math.round(EasyMath.invLerp(z, this.zMin, this.zMax) * (float)this.d))) < 0 || ix >= this.w || iy >= this.h || iz >= this.d) {
            return this.outer;
        }
        return this.cells[ix][iy][iz];
    }
}

