/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet.liquid;

import craterstudio.math.EasyMath;
import craterstudio.math.Vec3;
import craterstudio.util.Bag;
import craterstudio.verlet.VerletSphere;
import craterstudio.verlet.liquid.VerletLiquidGrid;
import craterstudio.verlet.liquid.VerletLiquidVisitor;

public class VerletLiquidGridXY
implements VerletLiquidGrid {
    private final float xMin;
    private final float xMax;
    private final float yMin;
    private final float yMax;
    final float size;
    private final int w;
    private final int h;
    private final Bag<VerletSphere>[][] cells;
    private final Bag<VerletSphere>[][] filled;
    final Bag<VerletSphere> outer;

    VerletLiquidGridXY(float xMin, float xMax, float yMin, float yMax, float size) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.size = size;
        this.w = (int)Math.ceil((xMax - xMin) / size);
        this.h = (int)Math.ceil((yMax - yMin) / size);
        this.cells = new Bag[this.w][this.h];
        this.filled = new Bag[this.w][this.h];
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                this.cells[x][y] = new Bag();
                this.filled[x][y] = new Bag();
                ++x;
            }
            ++y;
        }
        this.outer = new Bag();
    }

    @Override
    public float getCellSize() {
        return this.size;
    }

    @Override
    public Bag<VerletSphere> getOuterSpheres() {
        return this.outer;
    }

    @Override
    public VerletLiquidGridXY copy(float size) {
        return new VerletLiquidGridXY(this.xMin, this.xMax, this.yMin, this.yMax, size);
    }

    @Override
    public void clear() {
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                this.cells[x][y].clear();
                ++x;
            }
            ++y;
        }
        this.outer.clear();
    }

    @Override
    public void put(VerletSphere sphere) {
        this.lookupCell(sphere.p.now).put(sphere);
    }

    @Override
    public void queryBoundingBox(VerletSphere bounds, Bag<VerletSphere> fill) {
        Vec3 center = bounds.p.now;
        Vec3 min = new Vec3(center).sub(bounds.radius);
        Vec3 max = new Vec3(center).add(bounds.radius);
        int neighbours = 1;
        int x1 = Math.round(EasyMath.invLerp(min.x, this.xMin, this.xMax) * (float)this.w) - neighbours;
        int x2 = Math.round(EasyMath.invLerp(max.x, this.xMin, this.xMax) * (float)this.w) + neighbours;
        int y1 = Math.round(EasyMath.invLerp(min.y, this.yMin, this.yMax) * (float)this.h) - neighbours;
        int y2 = Math.round(EasyMath.invLerp(max.y, this.yMin, this.yMax) * (float)this.h) + neighbours;
        this.fillFor(x1, x2, y1, y2, fill);
    }

    @Override
    public void visit(VerletLiquidVisitor visitor) {
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                if (this.cells[x][y].size() != 0) {
                    visitor.visit(x, y, 0, this.cells[x][y], this.filled[x][y]);
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public int outerCount() {
        return this.outer.size();
    }

    @Override
    public void tick() {
        int x = 0;
        while (x < this.w) {
            int y = 0;
            while (y < this.h) {
                this.filled[x][y].shrink();
                this.filled[x][y].clear();
                this.fillFor(x - 1, x + 1, y - 1, y + 1, this.filled[x][y]);
                ++y;
            }
            ++x;
        }
    }

    private void fillFor(int x1, int x2, int y1, int y2, Bag<VerletSphere> fill) {
        boolean putOuter = false;
        int iy = y1;
        while (iy <= y2) {
            int ix = x1;
            while (ix <= x2) {
                if ((ix | iy) < 0 || ix >= this.w || iy >= this.h) {
                    putOuter = true;
                } else {
                    fill.putAll(this.cells[ix][iy]);
                }
                ++ix;
            }
            ++iy;
        }
        if (putOuter) {
            fill.putAll(this.outer);
        }
    }

    private Bag<VerletSphere> lookupCell(Vec3 v) {
        return this.lookupCell(v.x, v.y);
    }

    private Bag<VerletSphere> lookupCell(float x, float y) {
        int iy;
        int ix = Math.round(EasyMath.invLerp(x, this.xMin, this.xMax) * (float)this.w);
        if ((ix | (iy = Math.round(EasyMath.invLerp(y, this.yMin, this.yMax) * (float)this.h))) < 0 || ix >= this.w || iy >= this.h) {
            return this.outer;
        }
        return this.cells[ix][iy];
    }
}

