/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet.liquid;

import craterstudio.verlet.liquid.VerletLiquid;
import craterstudio.verlet.liquid.VerletLiquidGrid;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VerletLiquidAnalyzer {
    private final VerletLiquid liquid;
    private boolean toggler;
    private long tSmaller;
    private long tLarger;
    private VerletLiquidGrid smallerGrid;
    private VerletLiquidGrid largerGrid;
    private final Map<Float, VerletLiquidGrid> size2grid;
    private final Set<Float> lastSizes;

    public VerletLiquidAnalyzer(VerletLiquid liquid, VerletLiquidGrid grid) {
        this.liquid = liquid;
        this.smallerGrid = grid;
        this.largerGrid = grid.copy(grid.getCellSize());
        this.size2grid = new HashMap<Float, VerletLiquidGrid>();
        this.lastSizes = new HashSet<Float>();
    }

    public void tick() {
        VerletLiquidGrid xy = this.toggler ? this.smallerGrid : this.largerGrid;
        this.lastSizes.add(Float.valueOf(xy.getCellSize()));
        long t0 = System.nanoTime();
        this.liquid.tickImpl(xy);
        long t1 = System.nanoTime();
        long t = t1 - t0;
        if (this.toggler) {
            this.tSmaller = t;
        } else {
            this.tLarger = t;
        }
        if (this.lastSizes.size() == 4) {
            HashSet remove = new HashSet();
            remove.addAll(this.size2grid.keySet());
            remove.removeAll(this.lastSizes);
            this.lastSizes.clear();
            for (Float f : remove) {
                this.size2grid.remove(f);
            }
        }
        this.toggler ^= true;
        if (!this.toggler) {
            return;
        }
        if (this.tSmaller < this.tLarger) {
            this.tLarger = this.tSmaller;
            this.largerGrid = this.smallerGrid;
            float newSize = this.smallerGrid.getCellSize() / 1.1f;
            if (newSize < this.liquid.getDropRadius()) {
                return;
            }
            VerletLiquidGrid smaller = this.size2grid.get(Float.valueOf(newSize));
            if (smaller == null) {
                smaller = this.smallerGrid.copy(newSize);
                this.size2grid.put(Float.valueOf(newSize), smaller);
            }
            this.smallerGrid = smaller;
        } else if (this.tSmaller > this.tLarger) {
            this.tSmaller = this.tLarger;
            this.smallerGrid = this.largerGrid;
            float newStep = this.smallerGrid.getCellSize() * 1.1f;
            VerletLiquidGrid larger = this.size2grid.get(Float.valueOf(newStep));
            if (larger == null) {
                larger = this.largerGrid.copy(newStep);
                this.size2grid.put(Float.valueOf(newStep), larger);
            }
            this.largerGrid = larger;
        }
    }
}

