/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet.liquid;

import craterstudio.math.Vec3;
import craterstudio.util.Bag;
import craterstudio.verlet.VerletBody;
import craterstudio.verlet.VerletBodyActor;
import craterstudio.verlet.VerletMath;
import craterstudio.verlet.VerletParticle;
import craterstudio.verlet.VerletPlane;
import craterstudio.verlet.VerletSphere;
import craterstudio.verlet.liquid.VerletLiquidAnalyzer;
import craterstudio.verlet.liquid.VerletLiquidGrid;
import craterstudio.verlet.liquid.VerletLiquidVisitor;
import craterstudio.verlet.liquid.VerletLiquidWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class VerletLiquid
extends VerletBody
implements VerletBodyActor {
    private final float dropRadius;
    private final float dropWeight;
    private final float viscosity;
    private final VerletLiquidAnalyzer analyzer;
    private final VerletLiquidWorker worker;
    private final List<VerletBody> interacting;

    public VerletLiquid(float dropRadius, float dropWeight, float viscosity, VerletLiquidGrid grid) {
        this.dropRadius = dropRadius;
        this.dropWeight = dropWeight;
        this.viscosity = viscosity;
        this.interacts = false;
        this.interacting = new ArrayList<VerletBody>();
        this.attach(this);
        float cellSize = dropRadius * 8.1234f;
        this.analyzer = new VerletLiquidAnalyzer(this, grid.copy(cellSize));
        this.worker = new VerletLiquidWorker(4);
    }

    public float getDropRadius() {
        return this.dropRadius;
    }

    public void addDrop(float x, float y, float z) {
        VerletParticle part = new VerletParticle();
        part.invWeight = 1.0f / this.dropWeight;
        part.translate(x, y, z);
        VerletSphere drop = new VerletSphere(part, this.dropRadius);
        this.addSphere(drop);
    }

    public void interact(VerletBody body) {
        this.interacting.add(body);
    }

    @Override
    public void act(VerletBody self) {
        if (this != self) {
            throw new IllegalStateException();
        }
        this.analyzer.tick();
    }

    public VerletLiquidVisitor createVisitor() {
        final VerletPlane p2 = VerletPlane.infer(new Vec3(0.0f, 0.0f, 0.0f), new Vec3(1.0f, 0.0f, 0.0f));
        final VerletPlane p3 = VerletPlane.infer(new Vec3(1280.0f, 0.0f, 0.0f), new Vec3(0.0f, 0.0f, 0.0f));
        return new VerletLiquidVisitor(){

            @Override
            public void visit(int x, int y, int z, Bag<VerletSphere> local, Bag<VerletSphere> surround) {
                float maxVel = 10.0f;
                Vec3 vel1 = new Vec3();
                Vec3 vel2 = new Vec3();
                float viscosity = VerletLiquid.this.viscosity;
                int i = 0;
                while (i < local.size()) {
                    VerletSphere drop = local.get(i);
                    drop.getParticle().getVelocity(vel1);
                    if (VerletMath.collides(p2, drop)) {
                        VerletMath.collide(p2, drop);
                    }
                    if (VerletMath.collides(p3, drop)) {
                        VerletMath.collide(p3, drop);
                    }
                    int size = surround.size();
                    int k = 0;
                    while (k < size) {
                        VerletSphere other = surround.get(k);
                        if (drop != other) {
                            VerletMath.collideLiquid(drop, other, viscosity);
                        }
                        ++k;
                    }
                    drop.getParticle().getVelocity(vel2);
                    if (vel2.length() > 2.0f && vel2.length() / vel1.length() > 2.0f) {
                        drop.getParticle().setVelocity(0.0f, 0.0f, 0.0f);
                    }
                    ++i;
                }
            }
        };
    }

    void tickImpl(VerletLiquidGrid liquidGrid) {
        List<VerletSphere> drops = this.listSpheres();
        liquidGrid.clear();
        int i = 0;
        while (i < drops.size()) {
            liquidGrid.put(drops.get(i));
            ++i;
        }
        liquidGrid.tick();
        this.worker.collide(this, liquidGrid);
        Bag<VerletSphere> fill = new Bag<VerletSphere>();
        int c = 0;
        for (VerletBody body : this.interacting) {
            liquidGrid.queryBoundingBox(body.boundingSphere, fill);
            int i2 = 0;
            while (i2 < fill.size()) {
                VerletSphere b = fill.get(i2);
                for (VerletSphere a : body.listSpheres()) {
                    if (!VerletMath.collides(a, b)) continue;
                    VerletMath.collide(a, b);
                    ++c;
                }
                ++i2;
            }
            fill.clear();
        }
        Random r = new Random();
        int off = 0;
        VerletSphere ground = new VerletSphere(-1.0f);
        ground.p.invWeight = 0.1f;
        int i3 = 0;
        while (i3 < 10) {
            ground.radius = 150 + i3 * 25;
            ground.p.setPosition(200 + i3 * 133 - (i3 == 0 ? 150 : 0), 200 + (i3 == 0 ? -250 : (i3 == 1 ? 75 : 0)) + i3 * 5, 0.0f);
            liquidGrid.queryBoundingBox(ground, fill);
            VerletMath.collide(ground, fill);
            fill.clear();
            ++i3;
        }
        off = 1100;
        int size = liquidGrid.getOuterSpheres().size();
        int i4 = 0;
        while (i4 < size) {
            VerletSphere drop = liquidGrid.getOuterSpheres().get(i4);
            drop.getParticle().setPosition((float)off + r.nextFloat() * 128.0f, 1200.0f + r.nextFloat() * 128.0f, 0.0f);
            drop.getParticle().setVelocity(0.0f, 0.0f, 0.0f);
            ++i4;
        }
    }
}

