/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet;

import craterstudio.math.Vec3;
import craterstudio.util.Bag;
import craterstudio.verlet.VerletBody;
import craterstudio.verlet.VerletFeedback;
import craterstudio.verlet.VerletParticle;
import craterstudio.verlet.VerletPlane;
import craterstudio.verlet.VerletSphere;
import craterstudio.verlet.VerletSpring;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VerletWorld {
    private Bag<VerletBody> bodies = new Bag();
    private Bag<VerletPlane> planes = new Bag();
    private Bag<VerletSpring> springs = new Bag();
    private float xGrav;
    private float yGrav;
    private float zGrav;

    public void addPlane(VerletPlane plane) {
        this.planes.put(plane);
    }

    public void addBody(VerletBody body) {
        this.bodies.put(body);
    }

    public void setGravity(float x, float y, float z) {
        this.xGrav = x;
        this.yGrav = y;
        this.zGrav = z;
    }

    public void addForce(Vec3 vec) {
        this.addForce(vec.x, vec.y, vec.z);
    }

    public void addForce(float x, float y, float z) {
        int i = 0;
        while (i < this.bodies.size()) {
            for (VerletSphere sphere : this.bodies.get(i).listSpheres()) {
                sphere.getParticle().addForce(x, y, z);
            }
            ++i;
        }
    }

    public VerletSpring createGlobalSpring(VerletSphere a, VerletSphere b, float stiffness, int how) {
        return this.createGlobalSpring(a.p, b.p, stiffness, how);
    }

    public VerletSpring createGlobalSpring(VerletParticle a, VerletParticle b, float stiffness, int how) {
        VerletSpring spring = new VerletSpring(a, b);
        spring.setCurrentDistanceAsLength();
        spring.stf = stiffness;
        spring.how = how;
        this.springs.put(spring);
        return spring;
    }

    public List<VerletBody> listBodies() {
        ArrayList<VerletBody> list = new ArrayList<VerletBody>();
        int i = 0;
        while (i < this.bodies.size()) {
            list.add(this.bodies.get(i));
            ++i;
        }
        return list;
    }

    public void removeGlobalSpring(VerletSpring spring) {
        this.springs.take(spring);
    }

    private int[] createShuffledIndices(int len) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        int i = 0;
        while (i < len) {
            lst.add(i);
            ++i;
        }
        Collections.shuffle(lst);
        int[] arr = new int[len];
        int i2 = 0;
        while (i2 < len) {
            arr[i2] = (Integer)lst.get(i2);
            ++i2;
        }
        return arr;
    }

    public void step(VerletFeedback feedback) {
        if (this.xGrav != 0.0f || this.yGrav != 0.0f || this.zGrav != 0.0f) {
            int i = 0;
            while (i < this.bodies.size()) {
                for (VerletSphere sphere : this.bodies.get(i).listSpheres()) {
                    if (sphere.getParticle().invWeight == 0.0f) continue;
                    sphere.getParticle().addVelocity(this.xGrav, this.yGrav, this.zGrav);
                }
                ++i;
            }
        }
        Bag<VerletBody> iaBodies = new Bag<VerletBody>();
        int i = 0;
        while (i < this.bodies.size()) {
            if (this.bodies.get((int)i).interacts) {
                iaBodies.put(this.bodies.get(i));
            }
            ++i;
        }
        int[] iiBody = this.createShuffledIndices(iaBodies.size());
        int[] iBody = this.createShuffledIndices(this.bodies.size());
        int[] iPlane = this.createShuffledIndices(this.planes.size());
        int[] iSpring = this.createShuffledIndices(this.springs.size());
        int i2 = 0;
        while (i2 < iaBodies.size()) {
            ((VerletBody)iaBodies.get(i2)).updateBoundingSphere();
            ++i2;
        }
        i2 = 0;
        while (i2 < iaBodies.size()) {
            VerletBody aBody = (VerletBody)iaBodies.get(iiBody[i2]);
            int k = i2 + 1;
            while (k < iaBodies.size()) {
                VerletBody bBody = (VerletBody)iaBodies.get(iiBody[k]);
                if (aBody.isPotentialHit(bBody)) {
                    aBody.collide(bBody, feedback);
                }
                ++k;
            }
            ++i2;
        }
        int k = 0;
        while (k < this.planes.size()) {
            VerletPlane plane = this.planes.get(iPlane[k]);
            int i3 = 0;
            while (i3 < this.bodies.size()) {
                VerletBody body = this.bodies.get(iBody[i3]);
                if (body.isPotentialHit(plane)) {
                    body.collide(plane, feedback);
                }
                ++i3;
            }
            ++k;
        }
        i2 = 0;
        while (i2 < this.bodies.size()) {
            this.bodies.get(iBody[i2]).stepLocalSprings(feedback);
            ++i2;
        }
        k = 0;
        while (k < this.springs.size()) {
            this.springs.get(iSpring[k]).tick();
            ++k;
        }
        i2 = 0;
        while (i2 < this.bodies.size()) {
            VerletBody body = this.bodies.get(iBody[i2]);
            body.tick();
            for (VerletSphere sphere : body.listSpheres()) {
                sphere.p.tick();
                if (sphere.drag == 0.0f) continue;
                sphere.getParticle().mulVelocity(1.0f - sphere.drag);
            }
            ++i2;
        }
    }
}

