/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet;

import craterstudio.verlet.VerletParticle;
import craterstudio.verlet.VerletSpringActor;
import java.util.ArrayList;
import java.util.List;

public class VerletSpring {
    public static final int FIXED_LENGTH = 0;
    public static final int MIN_LENGTH = 1;
    public static final int MAX_LENGTH = 2;
    public final VerletParticle a;
    public final VerletParticle b;
    public float len;
    public float stf;
    public int how;
    private List<VerletSpringActor> actors;

    public VerletSpring(VerletParticle a, VerletParticle b) {
        this.a = a;
        this.b = b;
    }

    public void attach(VerletSpringActor actor) {
        if (this.actors == null) {
            this.actors = new ArrayList<VerletSpringActor>();
        }
        this.actors.add(actor);
    }

    public void detach(VerletSpringActor actor) {
        if (this.actors != null) {
            this.actors.remove(actor);
        }
    }

    public final float setCurrentDistanceAsLength() {
        float d;
        float dx = this.b.now.x - this.a.now.x;
        float dy = this.b.now.y - this.a.now.y;
        float dz = this.b.now.z - this.a.now.z;
        this.len = d = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        return d;
    }

    public final float tick() {
        if (this.actors != null) {
            int i = this.actors.size() - 1;
            while (i >= 0) {
                this.actors.get(i).act(this);
                --i;
            }
        }
        float ax = this.a.now.x;
        float ay = this.a.now.y;
        float az = this.a.now.z;
        float bx = this.b.now.x;
        float by = this.b.now.y;
        float bz = this.b.now.z;
        float dx = ax - bx;
        float dy = ay - by;
        float dz = az - bz;
        float dist = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (this.how == 1 ? dist > this.len : this.how == 2 && dist < this.len) {
            return 0.0f;
        }
        float tension = (this.len - dist) / dist;
        float force = tension * this.stf;
        float aw = this.a.invWeight;
        float bw = this.b.invWeight;
        float f1 = force * aw / (aw + bw);
        float f2 = force * bw / (aw + bw);
        this.a.now.x = ax + dx * f1;
        this.a.now.y = ay + dy * f1;
        this.a.now.z = az + dz * f1;
        this.b.now.x = bx - dx * f2;
        this.b.now.y = by - dy * f2;
        this.b.now.z = bz - dz * f2;
        return tension;
    }
}

