/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet;

import craterstudio.math.Vec3;
import craterstudio.verlet.VerletParticleActor;
import java.util.ArrayList;
import java.util.List;

public class VerletParticle {
    public final Vec3 now;
    public final Vec3 old = new Vec3();
    public float invWeight = 1.0f;
    private List<VerletParticleActor> actors;

    public VerletParticle() {
        this.now = new Vec3();
    }

    public void setInfiniteWeight() {
        this.invWeight = 0.0f;
    }

    public void setWeight(float weight) {
        this.invWeight = 1.0f / weight;
    }

    public void attach(VerletParticleActor actor) {
        if (this.actors == null) {
            this.actors = new ArrayList<VerletParticleActor>();
        }
        this.actors.add(actor);
    }

    public void detach(VerletParticleActor actor) {
        if (this.actors != null) {
            this.actors.remove(actor);
        }
    }

    public final void setPosition(Vec3 vec) {
        this.setPosition(vec.x, vec.y, vec.z);
    }

    public final void setPosition(float x, float y, float z) {
        float xVel = this.now.x - this.old.x;
        float yVel = this.now.y - this.old.y;
        float zVel = this.now.z - this.old.z;
        this.now.x = x;
        this.now.y = y;
        this.now.z = z;
        this.old.x = x - xVel;
        this.old.y = y - yVel;
        this.old.z = z - zVel;
    }

    public final void getPosition(Vec3 vec) {
        vec.x = this.now.x;
        vec.y = this.now.y;
        vec.z = this.now.z;
    }

    public void translate(Vec3 vec) {
        this.translate(vec.x, vec.y, vec.z);
    }

    public void translate(float x, float y, float z) {
        this.setPosition(this.now.x + x, this.now.y + y, this.now.z + z);
    }

    public final void addForce(Vec3 vec) {
        this.addForce(vec.x, vec.y, vec.z);
    }

    public final void addForce(float x, float y, float z) {
        this.addVelocity(x * this.invWeight, y * this.invWeight, z * this.invWeight);
    }

    public final void setVelocity(Vec3 vec) {
        this.setVelocity(vec.x, vec.y, vec.z);
    }

    public final void setVelocity(float x, float y, float z) {
        this.old.x = this.now.x - x;
        this.old.y = this.now.y - y;
        this.old.z = this.now.z - z;
    }

    public final void addVelocity(float x, float y, float z) {
        this.old.x -= x;
        this.old.y -= y;
        this.old.z -= z;
    }

    public final void getVelocity(Vec3 vec) {
        vec.x = this.now.x - this.old.x;
        vec.y = this.now.y - this.old.y;
        vec.z = this.now.z - this.old.z;
    }

    public final void mulVelocity(float factor) {
        float xNow = this.now.x;
        float yNow = this.now.y;
        float zNow = this.now.z;
        this.old.x = xNow - (xNow - this.old.x) * factor;
        this.old.y = yNow - (yNow - this.old.y) * factor;
        this.old.z = zNow - (zNow - this.old.z) * factor;
    }

    public final void tick() {
        if (this.actors != null) {
            int i = this.actors.size() - 1;
            while (i >= 0) {
                this.actors.get(i).act(this);
                --i;
            }
        }
        float xOld = this.old.x;
        float yOld = this.old.y;
        float zOld = this.old.z;
        this.old.x = this.now.x;
        this.old.y = this.now.y;
        this.old.z = this.now.z;
        this.now.x += this.now.x - xOld;
        this.now.y += this.now.y - yOld;
        this.now.z += this.now.z - zOld;
    }
}

