/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet;

import craterstudio.math.Vec3;
import craterstudio.math.VecMath;
import craterstudio.util.Bag;
import craterstudio.verlet.VerletPlane;
import craterstudio.verlet.VerletSphere;

public class VerletMath {
    private static final float ulp_zero = Math.ulp(0.0f);

    public static final boolean collides(VerletPlane a, VerletSphere b) {
        float dx = b.p.now.x - a.nx * a.d;
        float dy = b.p.now.y - a.ny * a.d;
        float dz = b.p.now.z - a.nz * a.d;
        return a.nx * dx + a.ny * dy + a.nz * dz - b.radius < 0.0f;
    }

    public static final float collide(VerletPlane a, VerletSphere b) {
        float bx = b.p.now.x;
        float dx = bx - a.nx * a.d;
        float by = b.p.now.y;
        float dy = by - a.ny * a.d;
        float bz = b.p.now.z;
        float dz = bz - a.nz * a.d;
        float bd = b.radius;
        float dst = a.nx * dx + a.ny * dy + a.nz * dz - bd;
        if (dst >= 0.0f) {
            return 0.0f;
        }
        b.p.now.x = bx - dst * a.nx;
        b.p.now.y = by - dst * a.ny;
        b.p.now.z = bz - dst * a.nz;
        return -dst;
    }

    public static final void collide(VerletSphere target, Bag<VerletSphere> all) {
        int size = all.size();
        int i = 0;
        while (i < size) {
            VerletSphere sphere = all.get(i);
            if (VerletMath.collides(sphere, target)) {
                VerletMath.collide(sphere, target);
            }
            ++i;
        }
    }

    public static final boolean collides(VerletSphere a, VerletSphere b) {
        return VecMath.isInRange(a.p.now, b.p.now, a.radius + b.radius);
    }

    public static final void collideLiquid(VerletSphere a, VerletSphere b, float viscosity) {
        float rad = a.radius;
        Vec3 anow = a.p.now;
        Vec3 bnow = b.p.now;
        float bx = bnow.x;
        float ax = anow.x;
        float dx = bx - ax;
        float by = bnow.y;
        float ay = anow.y;
        float dy = by - ay;
        float bz = bnow.z;
        float az = anow.z;
        float dz = bz - az;
        float d2 = dx * dx + dy * dy + dz * dz;
        float outer = rad * 3.0f;
        if (d2 > outer * outer) {
            return;
        }
        float force = viscosity / d2;
        float dist = (float)Math.sqrt(d2);
        if (dist < rad * 2.0f) {
            if (dist > rad * 0.5f) {
                VerletMath.collide(a, b);
            }
            force *= -0.5f;
        } else {
            force *= 0.5f;
        }
        float fA = force;
        float fB = fA * -1.0f;
        a.p.addForce(dx * fA, dy * fA, dz * fA);
        b.p.addForce(dx * fB, dy * fB, dz * fB);
    }

    public static final float collide(VerletSphere a, VerletSphere b) {
        Vec3 anow = a.p.now;
        Vec3 bnow = b.p.now;
        float ax = anow.x;
        float ay = anow.y;
        float az = anow.z;
        float aiw = a.p.invWeight;
        float bx = bnow.x;
        float by = bnow.y;
        float bz = bnow.z;
        float biw = b.p.invWeight;
        float dx = bx - ax;
        float dy = by - ay;
        float dz = bz - az;
        float d2 = dx * dx + dy * dy + dz * dz;
        if (d2 <= ulp_zero) {
            return 0.0f;
        }
        float dMin = a.radius + b.radius;
        if (d2 > dMin * dMin) {
            return 0.0f;
        }
        float d = (float)Math.sqrt(d2);
        float f = (d - dMin) / dMin * 0.5f;
        float f1 = f * aiw / (aiw + biw);
        anow.x = ax + dx * f1;
        anow.y = ay + dy * f1;
        anow.z = az + dz * f1;
        float f2 = f * biw / (aiw + biw);
        bnow.x = bx - dx * f2;
        bnow.y = by - dy * f2;
        bnow.z = bz - dz * f2;
        return dMin - d;
    }
}

