/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet;

import craterstudio.verlet.VerletBody;
import craterstudio.verlet.VerletParticle;
import craterstudio.verlet.VerletSphere;
import java.util.List;

public class VerletBodyBuilder {
    public static VerletBody createBox(float sphereRadius, float overlap, int xUnits, int yUnits, int zUnits, float xOff, float yOff, float zOff) {
        int x;
        int y;
        VerletBody body = new VerletBody();
        float xDim = sphereRadius * (float)xUnits - overlap * (float)(xUnits - 1);
        float yDim = sphereRadius * (float)yUnits - overlap * (float)(yUnits - 1);
        float zDim = sphereRadius * (float)zUnits - overlap * (float)(zUnits - 1);
        float stiffness = 1.0f;
        int how = 0;
        VerletSphere[][][] grid = new VerletSphere[xUnits][yUnits][zUnits];
        int z = 0;
        while (z < zUnits) {
            y = 0;
            while (y < yUnits) {
                x = 0;
                while (x < xUnits) {
                    float xPos = xOff + sphereRadius * (float)x - xDim / 2.0f;
                    float yPos = yOff + sphereRadius * (float)y - yDim / 2.0f;
                    float zPos = zOff + sphereRadius * (float)z - zDim / 2.0f;
                    VerletParticle corner = new VerletParticle();
                    corner.setPosition(xPos, yPos, zPos);
                    VerletSphere verletSphere = new VerletSphere(corner, sphereRadius);
                    grid[x][y][z] = verletSphere;
                    body.addSphere(verletSphere);
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        z = 0;
        while (z < zUnits) {
            y = 0;
            while (y < yUnits) {
                x = 0;
                while (x < xUnits) {
                    if (x < xUnits - 1 && y < yUnits - 1 && z < zUnits - 1) {
                        body.createLocalSpring(grid[x + 0][y + 0][z + 0], grid[x + 1][y + 0][z + 0], stiffness, how);
                        body.createLocalSpring(grid[x + 0][y + 0][z + 0], grid[x + 0][y + 1][z + 0], stiffness, how);
                        body.createLocalSpring(grid[x + 0][y + 0][z + 0], grid[x + 0][y + 0][z + 1], stiffness, how);
                    }
                    if (x < xUnits - 1 && y < yUnits - 1) {
                        body.createLocalSpring(grid[x + 0][y + 0][z + 0], grid[x + 1][y + 1][z + 0], stiffness, how);
                        body.createLocalSpring(grid[x + 1][y + 0][z + 0], grid[x + 0][y + 1][z + 0], stiffness, how);
                    }
                    if (y < yUnits - 1 && z < zUnits - 1) {
                        body.createLocalSpring(grid[x + 0][y + 0][z + 0], grid[x + 0][y + 1][z + 1], stiffness, how);
                        body.createLocalSpring(grid[x + 0][y + 0][z + 1], grid[x + 0][y + 1][z + 0], stiffness, how);
                    }
                    if (z < zUnits - 1 && x < xUnits - 1) {
                        body.createLocalSpring(grid[x + 0][y + 0][z + 0], grid[x + 1][y + 0][z + 1], stiffness, how);
                        body.createLocalSpring(grid[x + 1][y + 0][z + 0], grid[x + 0][y + 0][z + 1], stiffness, how);
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return body;
    }

    public static VerletBody createCube(float dim, float xOff, float yOff, float zOff, boolean hifi) {
        int x;
        int y;
        VerletBody body = new VerletBody();
        float centerRadius = dim * 0.5f;
        float cornerRadius = centerRadius * 0.33f;
        cornerRadius *= centerRadius;
        float stiffness = 1.0f;
        int how = 0;
        int inc = hifi ? 1 : 2;
        VerletSphere[][][] grid = new VerletSphere[3][3][3];
        int z = -1;
        while (z < 2) {
            y = -1;
            while (y < 2) {
                x = -1;
                while (x < 2) {
                    float xPos = xOff + (float)x * centerRadius - (float)x * cornerRadius;
                    float yPos = yOff + (float)y * centerRadius - (float)y * cornerRadius;
                    float zPos = zOff + (float)z * centerRadius - (float)z * cornerRadius;
                    VerletParticle corner = new VerletParticle();
                    corner.setPosition(xPos, yPos, zPos);
                    VerletSphere verletSphere = new VerletSphere(corner, cornerRadius);
                    grid[x + 1][y + 1][z + 1] = verletSphere;
                    body.addSphere(verletSphere);
                    x += inc;
                }
                y += inc;
            }
            z += inc;
        }
        if (hifi) {
            z = -1;
            while (z < 2) {
                y = -1;
                while (y < 2) {
                    x = -1;
                    while (x < 2) {
                        if (x != 1 && y != 1 && z != 1) {
                            body.createLocalSpring(grid[x + 1][y + 1][z + 1], grid[x + 2][y + 1][z + 1], stiffness, how);
                            body.createLocalSpring(grid[x + 1][y + 1][z + 1], grid[x + 1][y + 2][z + 1], stiffness, how);
                            body.createLocalSpring(grid[x + 1][y + 1][z + 1], grid[x + 1][y + 1][z + 2], stiffness, how);
                        }
                        if (x != 1 && z != 1) {
                            body.createLocalSpring(grid[x + 1][y + 1][z + 1], grid[x + 2][y + 1][z + 2], stiffness, how);
                            body.createLocalSpring(grid[x + 2][y + 1][z + 1], grid[x + 1][y + 1][z + 2], stiffness, how);
                        }
                        if (x != 1 && y != 1) {
                            body.createLocalSpring(grid[x + 1][y + 1][z + 1], grid[x + 2][y + 2][z + 1], stiffness, how);
                            body.createLocalSpring(grid[x + 2][y + 1][z + 1], grid[x + 1][y + 2][z + 1], stiffness, how);
                        }
                        if (y != 1 && z != 1) {
                            body.createLocalSpring(grid[x + 1][y + 1][z + 1], grid[x + 1][y + 2][z + 2], stiffness, how);
                            body.createLocalSpring(grid[x + 1][y + 1][z + 2], grid[x + 1][y + 2][z + 1], stiffness, how);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        } else {
            VerletParticle center = new VerletParticle();
            VerletSphere sphere = new VerletSphere(center, centerRadius);
            center.setPosition(xOff, yOff, zOff);
            body.addSphere(sphere);
            List<VerletSphere> spheres = body.listSpheres();
            int i = 0;
            while (i < spheres.size()) {
                int k = i + 1;
                while (k < spheres.size()) {
                    body.createLocalSpring(spheres.get(i), spheres.get(k), stiffness, how);
                    ++k;
                }
                ++i;
            }
        }
        return body;
    }
}

