/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet;

import craterstudio.math.Vec3;
import craterstudio.verlet.VerletBodyActor;
import craterstudio.verlet.VerletFeedback;
import craterstudio.verlet.VerletMath;
import craterstudio.verlet.VerletParticle;
import craterstudio.verlet.VerletPlane;
import craterstudio.verlet.VerletSphere;
import craterstudio.verlet.VerletSpring;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class VerletBody {
    private static final Set<VerletSphere> usedSpheres = new HashSet<VerletSphere>();
    private final List<VerletSphere> spheres = new ArrayList<VerletSphere>();
    private final List<VerletSpring> springs = new ArrayList<VerletSpring>();
    public final VerletSphere boundingSphere = new VerletSphere(new VerletParticle(), 0.0f);
    public boolean interacts = true;
    private List<VerletBodyActor> actors;

    public void attach(VerletBodyActor actor) {
        if (this.actors == null) {
            this.actors = new ArrayList<VerletBodyActor>();
        }
        this.actors.add(actor);
    }

    public void detach(VerletBodyActor actor) {
        if (this.actors != null) {
            this.actors.remove(actor);
        }
    }

    public void translate(Vec3 vec) {
        this.translate(vec.x, vec.y, vec.z);
    }

    public void translate(float x, float y, float z) {
        for (VerletSphere sphere : this.listSpheres()) {
            sphere.getParticle().translate(x, y, z);
        }
    }

    public void setPosition(Vec3 vec) {
        this.setPosition(vec.x, vec.y, vec.z);
    }

    public void setPosition(float x, float y, float z) {
        Vec3 tmp = new Vec3();
        Vec3 center = new Vec3();
        int counter = 0;
        for (VerletSphere sphere : this.listSpheres()) {
            sphere.getParticle().getPosition(tmp);
            center.add(tmp);
            ++counter;
        }
        center.mul(1.0f / (float)counter);
        tmp.load(x, y, z).sub(center);
        for (VerletSphere sphere : this.listSpheres()) {
            sphere.getParticle().translate(tmp);
        }
    }

    public final void setVelocity(Vec3 vec) {
        this.setVelocity(vec.x, vec.y, vec.z);
    }

    public final void setVelocity(float x, float y, float z) {
        for (VerletSphere sphere : this.listSpheres()) {
            sphere.getParticle().setVelocity(x, y, z);
        }
    }

    public void setDrag(float drag) {
        for (VerletSphere sphere : this.listSpheres()) {
            sphere.drag = drag;
        }
    }

    public final void addForce(Vec3 vec) {
        this.addForce(vec.x, vec.y, vec.z);
    }

    public final void addForce(float x, float y, float z) {
        for (VerletSphere sphere : this.listSpheres()) {
            sphere.getParticle().addForce(x, y, z);
        }
    }

    public void addSphere(VerletSphere s) {
        if (!usedSpheres.add(s)) {
            throw new IllegalStateException("Sphere already used in a Body");
        }
        this.spheres.add(s);
    }

    public List<VerletSphere> listSpheres() {
        return this.spheres;
    }

    public List<VerletSpring> listSprings() {
        return this.springs;
    }

    public void removeSphere(VerletSphere s) {
        if (!this.spheres.remove(s)) {
            throw new IllegalStateException("No such sphere in Body");
        }
        usedSpheres.remove(s);
    }

    public VerletSpring createLocalSpring(VerletSphere a, VerletSphere b, float stiffness, int how) {
        return this.createLocalSpring(a.p, b.p, stiffness, how);
    }

    public VerletSpring createLocalSpring(VerletParticle a, VerletParticle b, float stiffness, int how) {
        if (!this.hasParticle(a)) {
            throw new IllegalStateException();
        }
        if (!this.hasParticle(b)) {
            throw new IllegalStateException();
        }
        VerletSpring spring = new VerletSpring(a, b);
        spring.setCurrentDistanceAsLength();
        spring.stf = stiffness;
        spring.how = how;
        this.springs.add(spring);
        return spring;
    }

    public void removeLocalSpring(VerletSpring spring) {
        if (!this.springs.remove(spring)) {
            throw new NoSuchElementException();
        }
    }

    void stepLocalSprings(VerletFeedback feedback) {
        int i = 0;
        while (i < this.springs.size()) {
            float tension = this.springs.get(i).tick();
            feedback.springUpdate(this, this.springs.get(i), tension);
            ++i;
        }
    }

    private boolean hasParticle(VerletParticle p) {
        int i = 0;
        while (i < this.spheres.size()) {
            if (this.spheres.get((int)i).p.equals(p)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isPotentialHit(VerletBody that) {
        return VerletMath.collides(that.boundingSphere, this.boundingSphere);
    }

    public boolean isPotentialHit(VerletPlane that) {
        return VerletMath.collides(that, this.boundingSphere);
    }

    public void collide(VerletPlane that, VerletFeedback feedback) {
        for (VerletSphere s : this.spheres) {
            float depth = VerletMath.collide(that, s);
            if (depth == 0.0f) continue;
            feedback.collision(this, s, that, depth);
        }
    }

    public void collide(VerletBody that, VerletFeedback feedback) {
        if (this == that) {
            throw new IllegalArgumentException();
        }
        for (VerletSphere a : this.spheres) {
            for (VerletSphere b : that.spheres) {
                float depth = VerletMath.collide(a, b);
                if (depth == 0.0f) continue;
                feedback.collision(this, a, that, b, depth);
            }
        }
    }

    public void updateBoundingSphere() {
        if (this.spheres.isEmpty()) {
            this.boundingSphere.p.now.x = 0.0f;
            this.boundingSphere.p.now.y = 0.0f;
            this.boundingSphere.p.now.z = 0.0f;
            this.boundingSphere.radius = 0.0f;
            return;
        }
        float maxRadius = 0.0f;
        float minX = 2.1474836E9f;
        float minY = 2.1474836E9f;
        float minZ = 2.1474836E9f;
        float maxX = -2.1474836E9f;
        float maxY = -2.1474836E9f;
        float maxZ = -2.1474836E9f;
        for (VerletSphere s : this.spheres) {
            if (s.radius > maxRadius) {
                maxRadius = s.radius;
            }
            float px = s.p.now.x;
            float py = s.p.now.y;
            float pz = s.p.now.z;
            if (px < minX) {
                minX = px;
            }
            if (py < minY) {
                minY = py;
            }
            if (pz < minZ) {
                minZ = pz;
            }
            if (px > maxX) {
                maxX = px;
            }
            if (py > maxY) {
                maxY = py;
            }
            if (!(pz > maxZ)) continue;
            maxZ = pz;
        }
        float dimX = (maxX += maxRadius) - (minX -= maxRadius);
        float dimY = (maxY += maxRadius) - (minY -= maxRadius);
        float dimZ = (maxZ += maxRadius) - (minZ -= maxRadius);
        float dim = Math.max(Math.max(dimX, dimY), dimZ);
        this.boundingSphere.p.now.x = (minX + maxX) * 0.5f;
        this.boundingSphere.p.now.y = (minY + maxY) * 0.5f;
        this.boundingSphere.p.now.z = (minZ + maxZ) * 0.5f;
        this.boundingSphere.radius = dim * 0.5f;
    }

    public void tick() {
        if (this.actors != null) {
            int i = this.actors.size() - 1;
            while (i >= 0) {
                this.actors.get(i).act(this);
                --i;
            }
        }
    }
}

