/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.verlet;

import craterstudio.math.EasyMath;
import craterstudio.verlet.Animation;
import craterstudio.verlet.VerletSpring;
import craterstudio.verlet.VerletSpringActor;

public class AnimatingVerletSpringActor
implements VerletSpringActor {
    final long t1;
    final long t2;
    final Animation<VerletSpring> anim;
    int status;

    public AnimatingVerletSpringActor(long t1, long t2, Animation<VerletSpring> anim) {
        this.t1 = t1;
        this.t2 = t2;
        this.anim = anim;
    }

    @Override
    public void act(VerletSpring spring) {
        float t = EasyMath.invLerp(System.currentTimeMillis(), this.t1, this.t2);
        switch (this.status) {
            case 0: {
                if (t < 0.0f) {
                    return;
                }
                this.anim.begin(spring);
                ++this.status;
                break;
            }
            case 1: {
                if (t <= 1.0f) {
                    this.anim.step(spring, t);
                    break;
                }
                ++this.status;
                break;
            }
            case 2: {
                this.anim.end(spring);
                spring.detach(this);
                ++this.status;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

