/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.util.concur;

import craterstudio.misc.Result;
import craterstudio.util.concur.ConcurrentQueue;
import craterstudio.util.concur.OneTimeLock;
import java.util.concurrent.atomic.AtomicReference;

public class RunnableQueue {
    final ConcurrentQueue<Runnable> queue = new ConcurrentQueue(false);

    public void launch() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable task;
                while ((task = RunnableQueue.this.queue.consume()) != null) {
                    try {
                        task.run();
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            }
        }, "RunnableQueue").start();
    }

    public void later(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.queue.produce(task);
    }

    public <T> T sync(final Result<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        final AtomicReference ref = new AtomicReference();
        this.sync(new Runnable(){

            @Override
            public void run() {
                ref.set(task.get());
            }
        });
        return (T)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        final OneTimeLock notifyDone = new OneTimeLock();
        Object object = this.queue.mutex();
        synchronized (object) {
            this.queue.produce(task);
            this.queue.produce(new Runnable(){

                @Override
                public void run() {
                    notifyDone.release();
                }
            });
        }
        notifyDone.waitFor();
    }

    public OneTimeLock getBarrier() {
        final OneTimeLock lock = new OneTimeLock();
        this.later(new Runnable(){

            @Override
            public void run() {
                lock.release();
            }
        });
        return lock;
    }

    public void terminateLater() {
        this.queue.produce(null);
    }
}

