/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.util;

import craterstudio.text.Text;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JDialog;

public class HighLevel {
    public static List<File> lookupClassPath() {
        ClassLoader parent = HighLevel.class.getClassLoader();
        ArrayList<File> cp = new ArrayList<File>();
        if (parent instanceof URLClassLoader) {
            URL[] urls;
            URL[] uRLArray = urls = ((URLClassLoader)parent).getURLs();
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                String full = url.toExternalForm();
                if (full.startsWith("file:")) {
                    cp.add(new File(Text.after(full, "file:")));
                }
                ++n2;
            }
        }
        return cp;
    }

    public static Runnable createMainLauncher(String classpath, String mainclass, String ... args) throws Exception {
        return HighLevel.createMainLauncher(Text.split(classpath, File.pathSeparatorChar), mainclass, args);
    }

    public static Runnable createMainLauncher(String[] classpath, String mainclass, final String ... args) throws Exception {
        URL[] cpURLs = new URL[classpath.length];
        try {
            int i = 0;
            while (i < cpURLs.length) {
                cpURLs[i] = new File(classpath[i]).toURI().toURL();
                ++i;
            }
        }
        catch (MalformedURLException exc) {
            throw new IllegalArgumentException(exc);
        }
        URLClassLoader cl = new URLClassLoader(cpURLs);
        Class[] params = new Class[]{String[].class};
        final Method method = cl.loadClass(mainclass).getMethod("main", params);
        return new Runnable(){

            @Override
            public void run() {
                try {
                    method.invoke(null, new Object[]{args});
                }
                catch (InvocationTargetException exc) {
                    if (!(exc.getCause() instanceof ThreadDeath)) {
                        throw new IllegalStateException(exc.getCause());
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
    }

    public static final int iteratorElements(Iterator<?> it) {
        int counter = 0;
        while (it.hasNext()) {
            it.next();
            ++counter;
        }
        return counter;
    }

    public static final <T> T iteratorElement(Iterator<T> it, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n (" + n + ") must be >= 0");
        }
        int m = n;
        while (it.hasNext()) {
            T t = it.next();
            if (n-- != 0) continue;
            return t;
        }
        throw new NoSuchElementException("element @ " + m + " not available");
    }

    public static final <T> T notNull(T t) {
        return HighLevel.notNull(t, "ERROR");
    }

    public static final <T> T notEmpty(T t) {
        return HighLevel.notEmpty(t, "ERROR");
    }

    public static final <T> T in(T find, T[] arr) {
        return HighLevel.in(find, arr, "ERROR");
    }

    public static final <T> T notIn(T find, T[] arr) {
        return HighLevel.notIn(find, arr, "ERROR");
    }

    public static <T> int nullCount(T ... arr) {
        int count = 0;
        T[] TArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t == null) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public static final <T> T notNull(T t, String msg) {
        if (t == null) {
            throw new IllegalStateException(String.valueOf(msg) + ": WAS NULL");
        }
        return t;
    }

    public static final <T> T notEmpty(T t, String msg) {
        if (t == null) {
            throw new IllegalStateException(String.valueOf(msg) + ": NULL EMPTY");
        }
        if (t instanceof String) {
            if (((String)t).trim().length() == 0) {
                throw new IllegalStateException(String.valueOf(msg) + ": " + t + " STRING EMPTY");
            }
            return t;
        }
        if (t instanceof Collection) {
            if (((Collection)t).size() == 0) {
                throw new IllegalStateException(String.valueOf(msg) + ": " + t + " COLLECTION EMPTY");
            }
            return t;
        }
        if (t.getClass().isArray()) {
            if (Array.getLength(t) == 0) {
                throw new IllegalStateException(String.valueOf(msg) + ": " + t + " ARRAY EMPTY");
            }
            return t;
        }
        if (t instanceof Number) {
            if (t instanceof Byte && (Byte)t == 0) {
                throw new IllegalArgumentException(String.valueOf(msg) + ": BYTE EMPTY");
            }
            if (t instanceof Short && (Short)t == 0) {
                throw new IllegalArgumentException(String.valueOf(msg) + ": SHORT EMPTY");
            }
            if (t instanceof Character && ((Character)t).charValue() <= ' ') {
                throw new IllegalArgumentException(String.valueOf(msg) + ": CHAR EMPTY");
            }
            if (t instanceof Integer && (Integer)t == 0) {
                throw new IllegalArgumentException(String.valueOf(msg) + ": INT EMPTY");
            }
            if (t instanceof Long && (Long)t == 0L) {
                throw new IllegalArgumentException(String.valueOf(msg) + ": LONG EMPTY");
            }
            if (t instanceof Float && ((Float)t).floatValue() == 0.0f) {
                throw new IllegalArgumentException(String.valueOf(msg) + ": FLOAT EMPTY");
            }
            if (t instanceof Double && (Double)t == 0.0) {
                throw new IllegalArgumentException(String.valueOf(msg) + ": DOUBLE EMPTY");
            }
            return t;
        }
        if (t instanceof Boolean) {
            if (!((Boolean)t).booleanValue()) {
                throw new IllegalArgumentException(String.valueOf(msg) + ": BOOLEAN EMPTY");
            }
            return t;
        }
        return t;
    }

    public static final <T> T in(T find, T[] arr, String msg) {
        T[] TArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t == find || t != null && t.equals(find)) {
                return t;
            }
            ++n2;
        }
        throw new IllegalStateException(String.valueOf(msg) + ": " + find + " NOT IN " + Arrays.toString(arr));
    }

    public static final <T> T notIn(T find, T[] arr, String msg) {
        T[] TArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t == find || t != null && t.equals(find)) {
                throw new IllegalStateException(String.valueOf(msg) + ": " + find + " IN " + Arrays.toString(arr));
            }
            ++n2;
        }
        return find;
    }

    public static final void wait(Object lock) {
        try {
            lock.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    public static final void wait(Object lock, long ms) {
        try {
            lock.wait(ms);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void wait(Object lock, long waitMS, Condition con, boolean consumeInterrupts) {
        Object object = lock;
        synchronized (object) {
            while (con == null || con != null && !con.pass()) {
                block6: {
                    try {
                        lock.wait(waitMS);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!consumeInterrupts) break block6;
                        Thread.interrupted();
                    }
                }
                if (con == null) break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void notify(Object lock) {
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void notifyAll(Object lock) {
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    public static final String fieldToString(Class<?> clazz, int fieldValue, String def) {
        try {
            Field field;
            Field[] fieldArray = clazz.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                field = fieldArray[n2];
                if (field.getInt(null) == fieldValue) {
                    return field.getName();
                }
                ++n2;
            }
            fieldArray = clazz.getDeclaredFields();
            n = fieldArray.length;
            n2 = 0;
            while (n2 < n) {
                field = fieldArray[n2];
                if (Modifier.isPublic(field.getModifiers()) && field.getInt(null) == fieldValue) {
                    return field.getName();
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            if (def == null) {
                throw new IllegalArgumentException("Field-value (" + fieldValue + ") not found in class " + clazz.getName());
            }
            return def;
        }
        if (def == null) {
            throw new IllegalArgumentException("Field-value (" + fieldValue + ") not found in class " + clazz.getName());
        }
        return def;
    }

    public static final List<String> fieldToStrings(Class<?> clazz, int fieldValue) {
        try {
            Field field;
            LinkedList<String> fieldNames = new LinkedList<String>();
            Field[] fieldArray = clazz.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                field = fieldArray[n2];
                if (field.getInt(null) == fieldValue) {
                    fieldNames.add(field.getName());
                }
                ++n2;
            }
            fieldArray = clazz.getDeclaredFields();
            n = fieldArray.length;
            n2 = 0;
            while (n2 < n) {
                field = fieldArray[n2];
                if (Modifier.isPublic(field.getModifiers()) && field.getInt(null) == fieldValue) {
                    fieldNames.add(field.getName());
                }
                ++n2;
            }
            if (!fieldNames.isEmpty()) {
                return fieldNames;
            }
        }
        catch (Exception exc) {
            throw new IllegalArgumentException(exc);
        }
        throw new IllegalArgumentException("Field-value (" + fieldValue + ") not found in class " + clazz.getName());
    }

    public static final int stringToField(Class<?> clazz, String fieldName, int def) {
        try {
            Field field = clazz.getField(fieldName);
            if (field == null) {
                throw new IllegalStateException();
            }
            if (field.getType() != Integer.TYPE) {
                throw new IllegalStateException();
            }
            return (Integer)field.get(null);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public static final void setPropertyByPath(Object obj, String path, Object val) {
        HighLevel.propertyPathBy(obj, path, val, true);
    }

    public static final Object getPropertyByPath(Object obj, String path) {
        return HighLevel.propertyPathBy(obj, path, null, false);
    }

    private static final Object propertyPathBy(Object obj, String path, Object val, boolean set) {
        String orgPath = path;
        while (true) {
            int dot;
            if ((dot = path.indexOf(46)) == -1) {
                if (set) {
                    HighLevel.setProperty(obj, path, val);
                    return null;
                }
                return HighLevel.getProperty(obj, path);
            }
            if ((obj = HighLevel.getProperty(obj, path.substring(0, dot))) == null) {
                throw new NullPointerException("\"" + path.substring(0, dot) + "\"==null in \"" + orgPath + "\"");
            }
            path = path.substring(dot + 1);
        }
    }

    public static final void setProperty(Object obj, String property, Object val) {
        String methodName = "set" + Text.capitalizeFirstOnly(property);
        Method[] methodArray = obj.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                if (method.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException("Invalid property: " + property + ", return-type must be void");
                }
                if (method.getParameterTypes().length != 1) {
                    throw new IllegalStateException("Invalid property: " + property + ", must have 1 parameter");
                }
                try {
                    method.invoke(obj, val);
                    return;
                }
                catch (IllegalArgumentException exc) {
                    throw new IllegalStateException(exc.getMessage() + " prop=" + property + ", val=" + val.getClass().getSimpleName() + ", par=" + method.getParameterTypes()[0].getSimpleName());
                }
                catch (Exception exc) {
                    throw new IllegalStateException(exc);
                }
            }
            ++n2;
        }
        throw new IllegalStateException("Couldn't find property: " + property + " as " + methodName);
    }

    public static final Object getProperty(Object obj, String property) {
        int i = 0;
        while (i < 2) {
            String methodName = String.valueOf(i == 0 ? "get" : "is") + Text.capitalizeFirstOnly(property);
            Method[] methodArray = obj.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(methodName)) {
                    if (method.getReturnType() == Void.TYPE) {
                        throw new IllegalStateException("Invalid property: " + property + ", return-type must not be void");
                    }
                    if (method.getParameterTypes().length != 0) {
                        throw new IllegalStateException("Invalid property: " + property + ", must have 0 parameters");
                    }
                    try {
                        return method.invoke(obj, new Object[0]);
                    }
                    catch (Exception exc) {
                        throw new IllegalStateException(exc);
                    }
                }
                ++n2;
            }
            ++i;
        }
        throw new IllegalStateException("Couldn't find property: " + property);
    }

    public static final long gc() {
        long preUsed = HighLevel.memUsed();
        int i = 0;
        while (i < 4) {
            System.gc();
            ++i;
        }
        long postUsed = HighLevel.memUsed();
        return preUsed - postUsed;
    }

    public static long memUsed() {
        Runtime r = Runtime.getRuntime();
        return r.totalMemory() - r.freeMemory();
    }

    public static final void busySleep(long ms) {
        HighLevel.busyNanoSleep(ms * 1000000L);
    }

    public static final void busyNanoSleep(long ns) {
        long end = System.nanoTime() + ns;
        while (System.nanoTime() < end) {
            Thread.yield();
        }
    }

    public static final void sleep(long ms) {
        HighLevel.sleep(ms, true);
    }

    public static final void sleep(long ms, boolean consumeInterrupts) {
        if (ms < 0L) {
            return;
        }
        long end = System.nanoTime() / 1000000L + ms;
        while (System.nanoTime() / 1000000L < end) {
            try {
                long togo = end - System.nanoTime() / 1000000L;
                long sleep = togo / 2L + 1L;
                if (sleep <= 0L) continue;
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                if (consumeInterrupts) {
                    Thread.currentThread().interrupt();
                    Thread.interrupted();
                    continue;
                }
                return;
            }
        }
    }

    public static final int sizeof(Class<?> prim) {
        if (prim == Byte.TYPE || prim == Boolean.TYPE) {
            return 1;
        }
        if (prim == Short.TYPE || prim == Character.TYPE) {
            return 2;
        }
        if (prim == Integer.TYPE || prim == Float.TYPE) {
            return 4;
        }
        if (prim == Long.TYPE || prim == Double.TYPE) {
            return 8;
        }
        return -1;
    }

    public static JDialog createDialogFromComponentParent(Component c, boolean modal, boolean root) {
        Component target = null;
        while (c.getParent() != null) {
            if ((c = c.getParent()) instanceof Frame) {
                target = c;
                if (!root) break;
            }
            if (!(c instanceof Dialog)) continue;
            target = c;
            if (!root) break;
        }
        if (target instanceof Frame) {
            return new JDialog((Frame)target, modal);
        }
        if (target instanceof Dialog) {
            return new JDialog((Dialog)target, modal);
        }
        throw new IllegalStateException("Couldn't find root surface");
    }

    public static Field findDeclaredField(Class<?> clazz, String name) {
        do {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field fld = fieldArray[n2];
                if (fld.getName().equals(name)) {
                    return fld;
                }
                ++n2;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    public static Field[] findDeclaredFields(Class<?> clazz, String name) {
        ArrayList<Field> result = new ArrayList<Field>();
        do {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field fld = fieldArray[n2];
                if (fld.getName().equals(name)) {
                    result.add(fld);
                }
                ++n2;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return result.toArray(new Field[result.size()]);
    }

    public static Method findDeclaredMethod(Class<?> clazz, String name) {
        do {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method mthd = methodArray[n2];
                if (mthd.getName().equals(name)) {
                    return mthd;
                }
                ++n2;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Method[] findDeclaredMethods(Class<?> clazz, String name) {
        block10: {
            clz = clazz;
            result = new ArrayList<Method>();
            try {
                do {
                    var7_10 = clazz.getDeclaredMethods();
                    var6_8 = var7_10.length;
                    var5_6 = 0;
                    while (var5_6 < var6_8) {
                        block9: {
                            mthd1 = var7_10[var5_6];
                            if (mthd1.getName().equals(name)) {
                                for (Method mthd2 : result) {
                                    if (!mthd1.getReturnType().equals(mthd2.getReturnType()) || !Arrays.equals(c1 = mthd1.getParameterTypes(), c2 = mthd2.getParameterTypes())) {
                                        continue;
                                    }
                                    break block9;
                                }
                                result.add(mthd1);
                            }
                        }
                        ++var5_6;
                    }
                } while ((clazz = clazz.getSuperclass()) != null);
                break block10;
            }
            catch (AccessControlException v0) {
                result.clear();
                var7_11 = clz.getMethods();
                var6_9 = var7_11.length;
                var5_7 = 0;
                ** while (var5_7 < var6_9)
            }
lbl-1000:
            // 1 sources

            {
                mthd = var7_11[var5_7];
                if (mthd.getName().equals(name)) {
                    result.add(mthd);
                }
                ++var5_7;
                continue;
            }
        }
        return result.toArray(new Method[result.size()]);
    }

    public static Field[] forceAccess(Field ... flds) {
        try {
            Field[] fieldArray = flds;
            int n = flds.length;
            int n2 = 0;
            while (n2 < n) {
                Field fld = fieldArray[n2];
                if (!fld.isAccessible()) {
                    fld.setAccessible(true);
                }
                ++n2;
            }
        }
        catch (AccessControlException accessControlException) {}
        return flds;
    }

    public static Method[] forceAccess(Method ... mthds) {
        try {
            Method[] methodArray = mthds;
            int n = mthds.length;
            int n2 = 0;
            while (n2 < n) {
                Method mthd = methodArray[n2];
                if (!mthd.isAccessible()) {
                    mthd.setAccessible(true);
                }
                ++n2;
            }
            return mthds;
        }
        catch (AccessControlException accessControlException) {
            return mthds;
        }
    }

    public static interface Condition {
        public boolean pass();
    }
}

