/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.util;

import craterstudio.util.ArrayUtil;
import java.util.NoSuchElementException;

public class Bag<T> {
    private T[] data;
    private int size;

    public Bag() {
        this(4);
    }

    public Bag(int space) {
        this.data = new Object[space];
    }

    public void put(T t) {
        this.data = ArrayUtil.ensure(this.data, this.size + 1, 1.75f);
        this.data[this.size++] = t;
    }

    public void putAll(Bag<T> bag) {
        this.data = ArrayUtil.ensure(this.data, this.size + bag.size, 1.75f);
        System.arraycopy(bag.data, 0, this.data, this.size, bag.size);
        this.size += bag.size;
    }

    public T get(int i) {
        if (i > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[i];
    }

    public T take(int i) {
        if (i > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        T took = this.data[i];
        this.data[i] = this.data[--this.size];
        this.data[this.size] = null;
        return took;
    }

    public T take(T t) {
        int i = this.indexOf(t);
        if (i == -1) {
            throw new NoSuchElementException();
        }
        return this.take((T)i);
    }

    public boolean contains(T t) {
        return this.indexOf(t) != -1;
    }

    public int indexOf(T t) {
        int i = 0;
        while (i < this.size) {
            if (this.data[i] == t) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void shrink() {
        int factor;
        if (this.data.length > 8 && this.size < this.data.length / (factor = 4)) {
            int newSize = Math.max(4, this.size);
            Object[] newData = ArrayUtil.alloc(Object.class, newSize);
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.size) {
            this.data[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public int capacity() {
        return this.data.length;
    }

    public int size() {
        return this.size;
    }
}

