/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ArrayUtil {
    public static <T> void randomSelection(List<T> input, int elements, List<T> output) {
        if (input.size() <= elements) {
            throw new IllegalStateException();
        }
        if (!output.isEmpty()) {
            throw new IllegalStateException();
        }
        int[] mapping = new int[input.size()];
        int i = 0;
        while (i < mapping.length) {
            mapping[i] = i;
            ++i;
        }
        Random r = new Random();
        int len = mapping.length;
        while (len > elements) {
            mapping[r.nextInt((int)len)] = mapping[len - 1];
            --len;
        }
        if (output instanceof ArrayList) {
            ((ArrayList)output).ensureCapacity(elements);
        }
        int i2 = 0;
        while (i2 < elements) {
            output.add(input.get(mapping[i2]));
            ++i2;
        }
    }

    public static <T> T[] randomSelection(T[] input, int elements) {
        int[] mapping = new int[input.length];
        int i = 0;
        while (i < mapping.length) {
            mapping[i] = i;
            ++i;
        }
        Random r = new Random();
        int len = mapping.length;
        while (len > elements) {
            mapping[r.nextInt((int)len)] = mapping[len - 1];
            --len;
        }
        Object[] output = new Object[elements];
        int i2 = 0;
        while (i2 < elements) {
            output[i2] = input[mapping[i2]];
            ++i2;
        }
        return output;
    }

    public static void swap(Object[] array, int a, int b) {
        ArrayUtil.swap(array, a, b, array.length);
    }

    public static void swap(Object[] array, int a, int b, int max) {
        if ((a | b) < 0 || a >= max || b >= max || max > array.length) {
            throw new IllegalArgumentException();
        }
        Object t = array[b];
        array[b] = array[a];
        array[a] = t;
    }

    public static final boolean[] growBy(boolean[] src, int inc) {
        return ArrayUtil.growTo(src, src.length + inc);
    }

    public static final boolean[] growTo(boolean[] src, int capacity) {
        boolean[] dst = new boolean[capacity];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static final boolean[] copyRange(boolean[] src, int off, int len) {
        boolean[] dst = new boolean[len];
        System.arraycopy(src, off, dst, 0, len);
        return dst;
    }

    public static final byte[] growBy(byte[] src, int inc) {
        return ArrayUtil.growTo(src, src.length + inc);
    }

    public static final byte[] growTo(byte[] src, int capacity) {
        byte[] dst = new byte[capacity];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static final byte[] copyRange(byte[] src, int off, int len) {
        byte[] dst = new byte[len];
        System.arraycopy(src, off, dst, 0, len);
        return dst;
    }

    public static final short[] growBy(short[] src, int inc) {
        return ArrayUtil.growTo(src, src.length + inc);
    }

    public static final short[] growTo(short[] src, int capacity) {
        short[] dst = new short[capacity];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static final short[] copyRange(short[] src, int off, int len) {
        short[] dst = new short[len];
        System.arraycopy(src, off, dst, 0, len);
        return dst;
    }

    public static final char[] growBy(char[] src, int inc) {
        return ArrayUtil.growTo(src, src.length + inc);
    }

    public static final char[] growTo(char[] src, int capacity) {
        char[] dst = new char[capacity];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static final char[] copyRange(char[] src, int off, int len) {
        char[] dst = new char[len];
        System.arraycopy(src, off, dst, 0, len);
        return dst;
    }

    public static final int[] growBy(int[] src, int inc) {
        return ArrayUtil.growTo(src, src.length + inc);
    }

    public static final int[] growTo(int[] src, int capacity) {
        int[] dst = new int[capacity];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static final int[] copyRange(int[] src, int off, int len) {
        int[] dst = new int[len];
        System.arraycopy(src, off, dst, 0, len);
        return dst;
    }

    public static final int[] splice(int[] src, int index, int ... insert) {
        int[] tmp = new int[src.length + insert.length];
        System.arraycopy(src, 0, tmp, 0, index);
        System.arraycopy(insert, 0, tmp, index, insert.length);
        System.arraycopy(src, index, tmp, index + insert.length, src.length - index);
        return tmp;
    }

    public static final long[] growBy(long[] src, int inc) {
        return ArrayUtil.growTo(src, src.length + inc);
    }

    public static final long[] growTo(long[] src, int capacity) {
        long[] dst = new long[capacity];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static final long[] copyRange(long[] src, int off, int len) {
        long[] dst = new long[len];
        System.arraycopy(src, off, dst, 0, len);
        return dst;
    }

    public static final float[] growBy(float[] src, int inc) {
        return ArrayUtil.growTo(src, src.length + inc);
    }

    public static final float[] growTo(float[] src, int capacity) {
        float[] dst = new float[capacity];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static final float[] copyRange(float[] src, int off, int len) {
        float[] dst = new float[len];
        System.arraycopy(src, off, dst, 0, len);
        return dst;
    }

    public static final double[] growBy(double[] src, int inc) {
        return ArrayUtil.growTo(src, src.length + inc);
    }

    public static final double[] growTo(double[] src, int capacity) {
        double[] dst = new double[capacity];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static final double[] copyRange(double[] src, int off, int len) {
        double[] dst = new double[len];
        System.arraycopy(src, off, dst, 0, len);
        return dst;
    }

    public static final <T> T[] growBy(T[] src, int inc) {
        return ArrayUtil.growTo(src, src.length + inc);
    }

    public static final <T> T[] growTo(T[] src, int capacity) {
        ?[] dst = ArrayUtil.alloc(src.getClass().getComponentType(), capacity);
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static final <T> T[] insert(T[] src, int index, T ... insert) {
        Object[] tmp = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length + insert.length);
        System.arraycopy(src, 0, tmp, 0, index);
        System.arraycopy(insert, 0, tmp, index, insert.length);
        System.arraycopy(src, index, tmp, index + insert.length, src.length - index);
        return tmp;
    }

    public static final <T> T[] remove(T[] src, int index, int elements) {
        Object[] tmp = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length - elements);
        System.arraycopy(src, 0, tmp, 0, index);
        System.arraycopy(src, index + 1, tmp, index, src.length - index - elements);
        return tmp;
    }

    public static final <T> T[] ensure(T[] src, int minCapacity, float factor) {
        if (src.length >= minCapacity) {
            return src;
        }
        int newCapacity = src.length + 1;
        while ((newCapacity = (int)((float)newCapacity * factor)) < minCapacity) {
        }
        return ArrayUtil.growTo(src, newCapacity);
    }

    public static final <T> T[] copyRange(T[] src, int off, int len) {
        Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), len);
        System.arraycopy(src, off, dst, 0, len);
        return dst;
    }

    public static final <T> T[] join(T[] a, T[] b) {
        return ArrayUtil.join(a, 0, a.length, b, 0, b.length);
    }

    public static final <T> T[] join(T[] a, int aOff, int aLen, T[] b, int bOff, int bLen) {
        Object[] dst = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, aOff, dst, 0, aLen);
        System.arraycopy(b, bOff, dst, aLen, bLen);
        return dst;
    }

    public static final <T> T[] alloc(Class<T> t, int capacity) {
        return (Object[])Array.newInstance(t, capacity);
    }
}

