/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.time;

public class Interval {
    private long timestamp;
    private long interval;

    public static Interval create(long delay, long interval) {
        return new Interval(interval, Interval.now() + delay - interval);
    }

    public Interval(long interval) {
        this(interval, Interval.now());
    }

    public Interval(long interval, long timestamp) {
        this.interval = interval;
        this.timestamp = timestamp;
    }

    public static final long now() {
        return System.nanoTime() / 1000000L;
    }

    public final long getInterval() {
        return this.interval;
    }

    public final long getTimeLeft() {
        long next = this.timestamp + this.interval;
        long left = next - Interval.now();
        return left;
    }

    public final void pass() {
        this.timestamp += this.interval;
    }

    public final void makeItLater() {
        long now = Interval.now();
        while (this.timestamp < now) {
            this.pass();
        }
    }

    public final boolean hasPassed() {
        boolean passed;
        boolean bl = passed = Interval.now() >= this.timestamp + this.interval;
        if (passed) {
            this.pass();
        }
        return passed;
    }

    public final boolean hasPassedAndMakeItLater() {
        boolean passed = this.hasPassed();
        if (passed) {
            this.makeItLater();
        }
        return passed;
    }
}

