/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.text;

import craterstudio.collection.lists.ByteList;
import craterstudio.util.PrettyRandom;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Text {
    private static final char[] table = "0123456789abcdef".toCharArray();
    private static final char[] src = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz01234567890".toCharArray();
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private static final String encoding = "ISO-8859-1";
    private static final char[] temp = new char[4];
    private static final char magic = '%';
    private static final char[] base16 = "0123456789ABCDEF".toCharArray();

    public static String hashAsHex(byte[] hash) {
        char[] table = Text.table;
        char[] digits = new char[hash.length << 1];
        int k = 0;
        while (k < hash.length) {
            byte h = hash[k];
            digits[k << 1 | 1] = table[h & 0xF];
            digits[k << 1] = table[(h & 0xF0) >> 4];
            ++k;
        }
        return new String(digits);
    }

    public static String generateRandomCode(int len) {
        return Text.generateRandomCode(len, src);
    }

    public static String generateRandomCode(int len, char[] chars) {
        return Text.generateRandomCode(len, chars, new PrettyRandom());
    }

    public static String generateRandomCode(int len, char[] chars, Random r) {
        char[] dst = new char[len];
        int i = 0;
        while (i < dst.length) {
            dst[i] = chars[r.nextInt(chars.length)];
            ++i;
        }
        return new String(dst);
    }

    public static final String formatString(String text, int length) {
        return Text.formatString(text, length, 0, ' ');
    }

    public static final String formatString(String text, int length, char c) {
        return Text.formatString(text, length, 0, c);
    }

    public static final String formatString(String text, int length, int type) {
        return Text.formatString(text, length, type, ' ');
    }

    public static final String formatString(String text, int length, int type, char c) {
        int i;
        int split;
        if (text.length() > length) {
            if (text.length() >= 3) {
                return String.valueOf(text.substring(0, length - 3)) + "...";
            }
            return "<?>";
        }
        char[] array = new char[length];
        if (type == 0) {
            split = text.length();
            i = 0;
            while (i < split) {
                array[i] = text.charAt(i);
                ++i;
            }
            i = split;
            while (i < length) {
                array[i] = c;
                ++i;
            }
        }
        if (type == 1) {
            throw new UnsupportedOperationException();
        }
        if (type == 2) {
            split = length - text.length();
            i = 0;
            while (i < split) {
                array[i] = c;
                ++i;
            }
            i = split;
            while (i < length) {
                array[i] = text.charAt(i - split);
                ++i;
            }
        }
        return new String(array);
    }

    public static final boolean onlyNumbers(String val) {
        char[] arr = val.toCharArray();
        int i = 0;
        while (i < arr.length) {
            char c = arr[i];
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean onlyLetters(String val) {
        char[] arr = val.toCharArray();
        int i = 0;
        while (i < arr.length) {
            char c = arr[i];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String ascii(byte[] raw, int off, int len) {
        char[] str = new char[len];
        int i = 0;
        while (i < len) {
            str[i] = (char)raw[off + i];
            ++i;
        }
        return new String(str);
    }

    public static final String ascii(byte[] raw) {
        char[] str = new char[raw.length];
        int i = 0;
        while (i < str.length) {
            str[i] = (char)raw[i];
            ++i;
        }
        return new String(str);
    }

    public static final byte[] ascii(String str) {
        byte[] raw = new byte[str.length()];
        int i = 0;
        while (i < raw.length) {
            raw[i] = (byte)str.charAt(i);
            ++i;
        }
        return raw;
    }

    public static final String utf8(byte[] raw) {
        return Text.utf8(raw, 0, raw.length);
    }

    public static final String utf8(byte[] raw, int off, int len) {
        try {
            return new String(raw, off, len, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException();
        }
    }

    public static final byte[] utf8(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException();
        }
    }

    public static final String convert(byte[] data) {
        return Text.convert(data, encoding);
    }

    public static final String convert(byte[] data, String encoding) {
        try {
            return new String(data, encoding);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String convert(byte[] data, int offset, int length) {
        try {
            return new String(data, offset, length, encoding);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final byte[] convert(String value) {
        try {
            return value.getBytes(encoding);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String chopLast(String value, int chars) {
        if (chars < 0 || chars > value.length()) {
            throw new IllegalArgumentException("invalid chars: " + chars + " / " + value.length());
        }
        return value.substring(0, value.length() - chars);
    }

    public static final String flip(String value) {
        char[] arr = value.toCharArray();
        int half = arr.length / 2;
        int end = arr.length - 1;
        int i = 0;
        while (i < half) {
            char c = arr[i];
            arr[i] = arr[end - i];
            arr[end - i] = c;
            ++i;
        }
        return String.valueOf(arr);
    }

    public static String firstOccurence(String text, String ... finds) {
        int min = Integer.MAX_VALUE;
        String first = null;
        String[] stringArray = finds;
        int n = finds.length;
        int n2 = 0;
        while (n2 < n) {
            String find = stringArray[n2];
            int i = text.indexOf(find);
            if (i != -1 && i < min) {
                min = i;
                first = find;
            }
            ++n2;
        }
        return first;
    }

    public static final String[] depthAwareSplit(String value, char split, char open, char close) {
        ArrayList<String> list = new ArrayList<String>();
        int depth = 0;
        int lastStart = 0;
        int i = 0;
        while (i < value.length()) {
            block8: {
                char c;
                block6: {
                    block7: {
                        block5: {
                            c = value.charAt(i);
                            if (c != open) break block5;
                            ++depth;
                            break block6;
                        }
                        if (c != close) break block7;
                        --depth;
                        break block6;
                    }
                    if (c != split || depth != 0) break block8;
                }
                list.add(value.substring(lastStart, c));
                lastStart = i + 1;
            }
            ++i;
        }
        if (lastStart != value.length()) {
            list.add(value.substring(lastStart));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String[] splitOnLines(String value) {
        return Text.split(Text.remove(value, '\r'), '\n');
    }

    public static final String[] split(String value, char d) {
        String[] buf = new String[Text.count(value, d) + 1];
        Text.split(value, d, buf);
        return buf;
    }

    public static final String[] split(String value, String d) {
        String[] pair;
        ArrayList<String> parts = new ArrayList<String>();
        String[] buf = new String[2];
        while ((pair = Text.splitPair(value, d, buf)) != null) {
            parts.add(pair[0]);
            value = pair[1];
        }
        parts.add(value);
        return parts.toArray(new String[parts.size()]);
    }

    public static final int split(String value, char d, String[] buf) {
        int count = 0;
        int n = value.length();
        int lastSplit = 0;
        int i = 0;
        while (i < n) {
            if (value.charAt(i) == d) {
                buf[count++] = value.substring(lastSplit, i);
                lastSplit = i + 1;
            }
            ++i;
        }
        buf[count++] = value.substring(lastSplit, n);
        return count;
    }

    public static final String[] splitPair(String pair, char d) {
        return Text.splitPair(pair, d, new String[2]);
    }

    public static final String[] splitPair(String pair, String d) {
        return Text.splitPair(pair, d, new String[2]);
    }

    public static final String[] splitPair(String pair, char d, String[] result) {
        int split = pair.indexOf(d);
        if (split == -1) {
            return null;
        }
        result[0] = pair.substring(0, split);
        result[1] = pair.substring(split + 1);
        return result;
    }

    public static final String[] splitPair(String pair, String d, String[] result) {
        int split = pair.indexOf(d);
        if (split == -1) {
            return null;
        }
        result[0] = pair.substring(0, split);
        result[1] = pair.substring(split + d.length());
        return result;
    }

    public static final String[] chop(String value, int size) {
        int fullParts = value.length() / size;
        int extra = value.length() % size != 0 ? 1 : 0;
        String[] part = new String[fullParts + extra];
        int i = 0;
        while (i < fullParts) {
            part[i] = value.substring(i * size, (i + 1) * size);
            ++i;
        }
        if (extra != 0) {
            part[fullParts] = value.substring(fullParts * size);
        }
        return part;
    }

    public static final String join(String[] value) {
        return Text.join(value, 0, value.length);
    }

    public static final String join(String[] value, char c) {
        return Text.join(value, 0, value.length, c);
    }

    public static final String join(String[] value, String s) {
        return Text.join(value, 0, value.length, s);
    }

    public static final String join(String[] value, int off, int len) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < len) {
            buffer.append(value[off + i]);
            ++i;
        }
        return buffer.toString();
    }

    public static final String join(String[] value, int off, int len, char c) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < len) {
            buffer.append(value[off + i]);
            if (i != len - 1) {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final String join(String[] value, int off, int len, String s) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < len) {
            buffer.append(value[off + i]);
            if (i != len - 1) {
                buffer.append(s);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final String[] multiSplit(String value, char ... cs) {
        int[] in = new int[cs.length];
        int or = 0;
        int i = 0;
        while (i < in.length) {
            in[i] = value.indexOf(cs[i], i == 0 ? 0 : in[i - 1] + 1);
            if ((or |= in[i]) < 0) {
                return null;
            }
            ++i;
        }
        String[] parts = new String[cs.length + 1];
        int i2 = 0;
        while (i2 < parts.length - 1) {
            parts[i2] = value.substring(i2 == 0 ? 0 : in[i2 - 1] + 1, in[i2]);
            ++i2;
        }
        parts[parts.length - 1] = value.substring(in[in.length - 1] + 1);
        return parts;
    }

    public static final String[] multiSplit(String value, String ... ss) {
        int[] in = new int[ss.length];
        int or = 0;
        int i = 0;
        while (i < ss.length) {
            in[i] = value.indexOf(ss[i], i == 0 ? 0 : in[i - 1] + ss[i - 1].length());
            if ((or |= in[i]) < 0) {
                return null;
            }
            ++i;
        }
        String[] parts = new String[ss.length + 1];
        int i2 = 0;
        while (i2 < parts.length - 1) {
            parts[i2] = value.substring(i2 == 0 ? 0 : in[i2 - 1] + ss[i2 - 1].length(), in[i2]);
            ++i2;
        }
        parts[parts.length - 1] = value.substring(in[in.length - 1] + ss[ss.length - 1].length());
        return parts;
    }

    public static final String[] multiSplitLoop(String value, char ... cs) {
        ArrayList<String> results = new ArrayList<String>();
        while (value != null) {
            String[] result = Text.multiSplit(value, cs);
            if (result == null) {
                results.add(value);
                value = null;
                continue;
            }
            int i = 0;
            while (i < result.length - 1) {
                results.add(result[i]);
                ++i;
            }
            value = result[result.length - 1];
        }
        return results.toArray(new String[results.size()]);
    }

    public static final String[] multiSplitLoop(String value, String ... ss) {
        ArrayList<String> results = new ArrayList<String>();
        while (value != null) {
            String[] result = Text.multiSplit(value, ss);
            if (result == null) {
                results.add(value);
                value = null;
                continue;
            }
            int i = 0;
            while (i < result.length - 1) {
                results.add(result[i]);
                ++i;
            }
            value = result[result.length - 1];
        }
        return results.toArray(new String[results.size()]);
    }

    public static String before(String text, char find) {
        int offset = text.indexOf(find);
        if (offset == -1) {
            return null;
        }
        return text.substring(0, offset);
    }

    public static String before(String text, String find) {
        int offset = text.indexOf(find);
        if (offset == -1) {
            return null;
        }
        return text.substring(0, offset);
    }

    public static String beforeLast(String text, char find) {
        int offset = text.lastIndexOf(find);
        if (offset == -1) {
            return null;
        }
        return text.substring(0, offset);
    }

    public static String beforeLast(String text, String find) {
        int offset = text.lastIndexOf(find);
        if (offset == -1) {
            return null;
        }
        return text.substring(0, offset);
    }

    public static String after(String text, char find) {
        int offset = text.indexOf(find);
        if (offset == -1) {
            return null;
        }
        return text.substring(offset + 1);
    }

    public static String after(String text, String find) {
        int offset = text.indexOf(find);
        if (offset == -1) {
            return null;
        }
        return text.substring(offset + find.length());
    }

    public static String afterLast(String text, char find) {
        int offset = text.lastIndexOf(find);
        if (offset == -1) {
            return null;
        }
        return text.substring(offset + 1);
    }

    public static String afterLast(String text, String find) {
        int offset = text.lastIndexOf(find);
        if (offset == -1) {
            return null;
        }
        return text.substring(offset + find.length());
    }

    public static String between(String text, char start, char end) {
        String after = Text.after(text, start);
        if (after == null) {
            return null;
        }
        return Text.before(after, end);
    }

    public static String between(String text, String start, String end) {
        String after = Text.after(text, start);
        if (after == null) {
            return null;
        }
        return Text.before(after, end);
    }

    public static String between(String text, char start, char end, String def) {
        return Text.replaceOnNull(Text.between(text, start, end), def);
    }

    public static String between(String text, String start, String end, String def) {
        return Text.replaceOnNull(Text.between(text, start, end), def);
    }

    private static String replaceOnNull(String text, String replace) {
        return text == null ? replace : text;
    }

    public static String beforeIfAny(String text, char find) {
        return Text.replaceOnNull(Text.before(text, find), text);
    }

    public static String beforeIfAny(String text, String find) {
        return Text.replaceOnNull(Text.before(text, find), text);
    }

    public static String beforeLastIfAny(String text, char find) {
        return Text.replaceOnNull(Text.beforeLast(text, find), text);
    }

    public static String beforeLastIfAny(String text, String find) {
        return Text.replaceOnNull(Text.beforeLast(text, find), text);
    }

    public static String afterIfAny(String text, char find) {
        return Text.replaceOnNull(Text.after(text, find), text);
    }

    public static String afterIfAny(String text, String find) {
        return Text.replaceOnNull(Text.after(text, find), text);
    }

    public static String afterLastIfAny(String text, char find) {
        return Text.replaceOnNull(Text.afterLast(text, find), text);
    }

    public static String afterLastIfAny(String text, String find) {
        return Text.replaceOnNull(Text.afterLast(text, find), text);
    }

    public static String before(String text, char find, String def) {
        return Text.replaceOnNull(Text.before(text, find), def);
    }

    public static String before(String text, String find, String def) {
        return Text.replaceOnNull(Text.before(text, find), def);
    }

    public static String beforeLast(String text, char find, String def) {
        return Text.replaceOnNull(Text.beforeLast(text, find), def);
    }

    public static String beforeLast(String text, String find, String def) {
        return Text.replaceOnNull(Text.beforeLast(text, find), def);
    }

    public static String after(String text, char find, String def) {
        return Text.replaceOnNull(Text.after(text, find), def);
    }

    public static String after(String text, String find, String def) {
        return Text.replaceOnNull(Text.after(text, find), def);
    }

    public static String afterLast(String text, char find, String def) {
        return Text.replaceOnNull(Text.afterLast(text, find), def);
    }

    public static String afterLast(String text, String find, String def) {
        return Text.replaceOnNull(Text.afterLast(text, find), def);
    }

    public static final int[] indicesOf(String s, char c) {
        int[] p = new int[Text.count(s, c)];
        int i = 0;
        int j = 0;
        while (i < s.length()) {
            if (s.charAt(i) == c) {
                p[j++] = i;
            }
            ++i;
        }
        return p;
    }

    public static final int[] indicesOf(String s, String m) {
        int off;
        if (m.length() == 0) {
            throw new IllegalArgumentException("empty match");
        }
        int[] p = new int[Text.count(s, m)];
        int i = 0;
        int offset = 0;
        while ((off = s.indexOf(m, offset)) != -1) {
            p[i++] = off;
            offset = off + m.length();
        }
        return p;
    }

    public static final int count(String s, char d) {
        int n = s.length();
        int x = 0;
        int i = 0;
        while (i < n) {
            if (s.charAt(i) == d) {
                ++x;
            }
            ++i;
        }
        return x;
    }

    public static final int count(String s, String d) {
        int off;
        int count = 0;
        int offset = 0;
        while ((off = s.indexOf(d, offset)) != -1) {
            ++count;
            offset = off + d.length();
        }
        return count;
    }

    public static final String replace(String s, char a, char b) {
        char[] array = s.toCharArray();
        int i = 0;
        while (i < array.length) {
            if (array[i] == a) {
                array[i] = b;
            }
            ++i;
        }
        return new String(array);
    }

    public static final String replace(String s, String a, String b) {
        StringBuffer sb = new StringBuffer();
        int len = a.length();
        int off = 0;
        while (true) {
            int found;
            if ((found = s.indexOf(a, off)) == -1) break;
            sb.append(s.substring(off, found));
            sb.append(b);
            off += found - off + len;
        }
        sb.append(s.substring(Math.min(off, s.length())));
        return sb.toString();
    }

    public static final String remove(String s, char c) {
        char[] array = s.toCharArray();
        int count = Text.count(s, c);
        char[] next = new char[array.length - count];
        int i = 0;
        int j = 0;
        while (i < array.length) {
            if (array[i] != c) {
                next[j++] = array[i];
            }
            ++i;
        }
        return new String(next);
    }

    public static final String remove(String s, char ... cs) {
        char[] array = s.toCharArray();
        int count = 0;
        char[] cArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            count += Text.count(s, c);
            ++n2;
        }
        char[] next = new char[array.length - count];
        int i = 0;
        int j = 0;
        while (i < array.length) {
            block4: {
                int k = 0;
                while (k < cs.length) {
                    if (array[i] != cs[k]) {
                        ++k;
                        continue;
                    }
                    break block4;
                }
                next[j++] = array[i];
            }
            ++i;
        }
        return new String(next);
    }

    public static final String remove(String s, String find) {
        return Text.replace(s, find, "");
    }

    public static final String convertWhiteSpaceTo(String s, char c) {
        char[] cs = s.toCharArray();
        int i = 0;
        while (i < cs.length) {
            if (cs[i] < ' ') {
                cs[i] = c;
            }
            ++i;
        }
        return new String(cs);
    }

    public static final int indexOfWhiteSpace(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) <= ' ') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final String[] splitOnWhiteSpace(String s) {
        s = Text.convertWhiteSpaceTo(s, ' ');
        s = Text.removeDuplicates(s, ' ');
        return Text.split(s, ' ');
    }

    public static final String[] splitPairOnWhiteSpace(String s) {
        s = Text.convertWhiteSpaceTo(s, ' ');
        s = Text.removeDuplicates(s, ' ');
        return Text.splitPair(s, ' ');
    }

    public static final String trimBefore(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) > ' ') {
                return s.substring(i);
            }
            ++i;
        }
        return "";
    }

    public static final String removeDuplicates(String s, char c) {
        char[] array = s.toCharArray();
        StringBuffer buffer = new StringBuffer();
        boolean duplicate = false;
        int i = 0;
        while (i < array.length) {
            if (array[i] != c) {
                buffer.append(array[i]);
                duplicate = false;
            } else if (!duplicate) {
                buffer.append(array[i]);
                duplicate = true;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final boolean contains(String[] array, String search) {
        if (search == null) {
            String[] stringArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s == null) {
                    return true;
                }
                ++n2;
            }
        } else {
            String[] stringArray = array;
            int n = array.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                if (search.equals(s)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public static final String capitalize(String value) {
        if (value.length() == 0) {
            return value;
        }
        if (value.length() == 1) {
            return value.toUpperCase();
        }
        return String.valueOf(value.substring(0, 1).toUpperCase()) + value.substring(1).toLowerCase();
    }

    public static final String capitalizeFirstOnly(String value) {
        if (value.length() == 0) {
            return value;
        }
        if (value.length() == 1) {
            return value.toUpperCase();
        }
        return String.valueOf(value.substring(0, 1).toUpperCase()) + value.substring(1);
    }

    public static final String decapitalizeFirstOnly(String value) {
        if (value.length() == 0) {
            return value;
        }
        if (value.length() == 1) {
            return value.toLowerCase();
        }
        return String.valueOf(value.substring(0, 1).toLowerCase()) + value.substring(1);
    }

    public static final Map<String, String> parseProperties(String value) {
        String[] lines;
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = lines = Text.splitOnLines(value);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pair;
            String line = stringArray[n2];
            line = Text.beforeIfAny(line, '#');
            if ((line = line.trim()).length() != 0 && (pair = Text.splitPair(line, '=')) != null) {
                String key = pair[0].trim();
                String val = pair[1].trim();
                map.put(key, val);
            }
            ++n2;
        }
        return map;
    }

    public static final Map<String, String> parseArgs(String value, String sep, String split) {
        String[] pairs = Text.split(value, sep);
        String[] part = new String[2];
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            if (pair.contains(String.valueOf(split))) {
                Text.splitPair(pair, split, part);
                map.put(part[0], part[1]);
            }
            ++n2;
        }
        return map;
    }

    public static final Map<String, String> parseArgs(String value, char sep, char split) {
        String[] pairs = Text.split(value, sep);
        String[] part = new String[2];
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            if (pair.contains(String.valueOf(split))) {
                Text.splitPair(pair, split, part);
                map.put(part[0], part[1]);
            }
            ++n2;
        }
        return map;
    }

    public static final String joinArgs(Map<String, String> map, String sep, String split) {
        StringBuffer sb = new StringBuffer();
        for (String key : map.keySet()) {
            sb.append(key);
            sb.append(split);
            sb.append(map.get(key));
            sb.append(sep);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static final String joinArgs(Map<String, String> map, char sep, char split) {
        StringBuffer sb = new StringBuffer();
        for (String key : map.keySet()) {
            sb.append(key);
            sb.append(split);
            sb.append(map.get(key));
            sb.append(sep);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static final String decodeURL(String encoded) {
        return Text.decodeURL(encoded, true);
    }

    public static final String decodeURL(String encoded, boolean decodePlus) {
        ByteList list = new ByteList();
        int i = 0;
        while (i < encoded.length()) {
            if (encoded.charAt(i) == '+' && decodePlus) {
                list.add((byte)32);
            } else if (encoded.charAt(i) == '%') {
                if (i + 2 >= encoded.length()) break;
                char c1 = encoded.charAt(++i);
                char c2 = encoded.charAt(++i);
                list.add((byte)(Text.chr2oct(c1) << 4 | Text.chr2oct(c2)));
            } else {
                list.add((byte)encoded.charAt(i));
            }
            ++i;
        }
        try {
            return new String(list.toArray(), encoding);
        }
        catch (UnsupportedEncodingException exc) {
            throw new IllegalStateException(exc);
        }
    }

    private static int chr2oct(char c) {
        int o = "0123456789ABCDEF".indexOf(c);
        if (o == -1) {
            o = "0123456789abcdef".indexOf(c);
        }
        if (o == -1) {
            throw new IllegalStateException();
        }
        return o;
    }

    public static final String simpleEncode(String message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < message.length()) {
            char c = message.charAt(i);
            if (c >= '0' && c <= '9') {
                sb.append(c);
            } else if (c >= 'a' && c <= 'z') {
                sb.append(c);
            } else if (c >= 'A' && c <= 'Z') {
                sb.append(c);
            } else {
                int cai = (c & 0xFFFF) << 4;
                int count = 0;
                while ((cai >>= 4) != 0) {
                    Text.temp[count++] = base16[cai & 0xF];
                }
                sb.append('%');
                int cnt = count - 1;
                while (cnt >= 0) {
                    sb.append(temp[cnt]);
                    --cnt;
                }
                sb.append('%');
            }
            ++i;
        }
        return sb.toString();
    }

    public static final String simpleDecode(String message) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < message.length()) {
            char c = message.charAt(i);
            if (c >= '0' && c <= '9') {
                sb.append(c);
            } else if (c >= 'a' && c <= 'z') {
                sb.append(c);
            } else if (c >= 'A' && c <= 'Z') {
                sb.append(c);
            } else if (c == '%') {
                int fullChar = 0;
                int k = 0;
                while (true) {
                    int oct;
                    int hex;
                    if ((hex = message.charAt(++i) & 0xFFFF) >= 48 && hex <= 57) {
                        oct = hex - 48;
                    } else if (hex >= 65 && hex <= 70) {
                        oct = hex - 65 + 10;
                    } else {
                        if (hex == 37) break;
                        throw new IllegalArgumentException("unexpected hex-char: " + hex);
                    }
                    fullChar = fullChar << 4 | oct;
                    ++k;
                }
                sb.append((char)fullChar);
            } else {
                throw new IllegalArgumentException("unexpected char: " + c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static final void mainArgsLookup(String[] args, Map<String, String> params) {
        for (String key : params.keySet()) {
            String val = Text.mainArgsLookup(args, key);
            if (val == null) {
                if (params.get(key) != null) continue;
                throw new IllegalStateException("parameter for -" + key + " not found, and no default value");
            }
            params.put(key, val);
        }
    }

    public static final String mainArgsLookup(String[] args, String key) {
        return Text.mainArgsLookup(args, key, null);
    }

    public static final String mainArgsLookup(String[] args, String key, String def) {
        return Text.mainArgsLookup(args, key, def, 0);
    }

    public static final List<String> mainArgsLookups(String[] args, String key) {
        key = "-" + key;
        ArrayList<String> matches = new ArrayList<String>();
        int i = 0;
        while (i < args.length - 1) {
            if (args[i].equals(key)) {
                matches.add(args[++i]);
            }
            ++i;
        }
        return matches;
    }

    public static final String mainArgsLookup(String[] args, String key, String def, int skip) {
        key = "-" + key;
        int i = 0;
        while (i < args.length - 1) {
            if (args[i].equals(key) && skip-- == 0) {
                return args[i + 1];
            }
            ++i;
        }
        return def;
    }

    public static boolean areCharsAt(String s, char c, int off1, int off2) {
        return s.charAt(off1) == c && s.charAt(off2) == c;
    }

    public static boolean areDigits(String s, int off, int len) {
        int end = off + len;
        int i = off;
        while (i < end) {
            if (s.charAt(i) < '0' || s.charAt(i) > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String urlencode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (IOException exc) {
            throw new IllegalStateException(exc);
        }
    }

    public static String urldecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (IOException exc) {
            throw new IllegalStateException(exc);
        }
    }
}

