/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.misc.gui;

import craterstudio.text.Text;
import craterstudio.util.concur.ConcurrentQueue;
import craterstudio.util.concur.CountdownLatch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class UserIO {
    static CustomUncaughtExceptionHandler excHandler;

    static {
        UserIO.setSystemLookAndFeel();
        excHandler = new CustomUncaughtExceptionHandler();
    }

    public static final void setSystemLookAndFeel() {
        try {
            String curLAF = UIManager.getLookAndFeel().getClass().getName();
            String newLAF = UIManager.getSystemLookAndFeelClassName();
            if (!curLAF.equals(newLAF)) {
                UIManager.setLookAndFeel(newLAF);
            }
        }
        catch (Exception exception) {}
    }

    public static void installErrorHandler(String appName) {
        excHandler.newThread(appName);
        Thread.setDefaultUncaughtExceptionHandler(excHandler);
        System.setProperty("sun.awt.exception.handler", AWTExceptionHandler.class.getName());
    }

    public static JFrame createDefaultHolder(Container container) {
        return UserIO.createDefaultHolder(container, true);
    }

    public static JFrame createDefaultHolder(Container container, boolean resizable) {
        JFrame frame = new JFrame();
        frame.setTitle("");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)container, "Center");
        frame.setResizable(resizable);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        return frame;
    }

    public static final void say(Component c, String title, String line) {
        JOptionPane.showMessageDialog(SwingUtilities.getRoot(c), line, " " + title, 1);
    }

    public static final void say(String title, String line) {
        JFrame frame = new JFrame();
        UserIO.say(frame, title, line);
        frame.dispose();
    }

    public static final void warn(Component c, String title, String line) {
        JOptionPane.showMessageDialog(SwingUtilities.getRoot(c), line, " " + title, 2);
    }

    public static final void warn(String title, String line) {
        JFrame frame = new JFrame();
        UserIO.warn(frame, title, line);
        frame.dispose();
    }

    public static final void alert(Component c, String title, String line) {
        JOptionPane.showMessageDialog(SwingUtilities.getRoot(c), line, " " + title, 0);
    }

    public static final void alert(String title, String line) {
        JFrame frame = new JFrame();
        UserIO.alert(frame, title, line);
        frame.dispose();
    }

    public static final boolean ask(Component c, String title, String line) {
        if (line.contains("\n")) {
            line = String.valueOf(line) + "\n";
        }
        return JOptionPane.showConfirmDialog(SwingUtilities.getRoot(c), line, " " + title, 0) == 0;
    }

    public static final boolean ask(String title, String line) {
        JFrame frame = new JFrame();
        boolean value = UserIO.ask(frame, title, line);
        frame.dispose();
        return value;
    }

    public static final String question(Component c, String title, String line) {
        return UserIO.question(c, title, line, "");
    }

    public static final String question(Component c, String title, String line, String defaultInput) {
        return (String)JOptionPane.showInputDialog(SwingUtilities.getRoot(c), line, " " + title, 3, null, null, defaultInput);
    }

    public static final String question(String title, String line) {
        JFrame frame = new JFrame();
        String value = UserIO.question(frame, title, line);
        frame.dispose();
        return value;
    }

    public static final CountdownLatch blockUI(Component c) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Cannot block UI from EDT");
        }
        final Component root = SwingUtilities.getRoot(c);
        final CountdownLatch dialogSignal = new CountdownLatch();
        final Dialog[] dialog = new Dialog[1];
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (root instanceof Frame) {
                    dialog[0] = new Dialog((Frame)root, "blocker", true);
                } else if (root instanceof Window) {
                    dialog[0] = new Dialog((Dialog)root, "blocker", true);
                } else {
                    throw new IllegalStateException("root not a frame or dialog");
                }
                dialog[0].setSize(128, 128);
                dialog[0].setLocation(-256, -256);
                dialog[0].setVisible(true);
                dialogSignal.countdown();
            }
        });
        final CountdownLatch userSignal = new CountdownLatch();
        new Thread(new Runnable(){

            @Override
            public void run() {
                dialogSignal.waitFor();
                userSignal.waitFor();
                dialog[0].dispose();
            }
        });
        return userSignal;
    }

    static String throwableDescription(Throwable t) {
        String type = t.getClass().getSimpleName();
        type = Text.beforeIfAny(type, "Exception");
        type = Text.beforeIfAny(type, "Error");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < type.length()) {
            if (i != 0 && Character.isUpperCase(type.charAt(i))) {
                sb.append(' ').append(Character.toLowerCase(type.charAt(i)));
            } else {
                sb.append(type.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static class AWTExceptionHandler {
        public void handle(Throwable t) {
            try {
                excHandler.uncaughtException(Thread.currentThread(), t);
            }
            catch (Throwable throwable) {}
        }
    }

    static class CustomUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        final ConcurrentQueue<Throwable> crashListener = new ConcurrentQueue(false);

        CustomUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.out.print("Exception in thread \"" + t.getName() + "\" ");
            e.printStackTrace(System.err);
            try {
                this.crashListener.produce(e);
            }
            catch (Throwable throwable) {}
        }

        void newThread(final String appName) {
            Thread crashThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        Throwable t = CustomUncaughtExceptionHandler.this.crashListener.consume();
                        String dialog = "";
                        dialog = String.valueOf(dialog) + appName + " has encountered an unexpected error:";
                        dialog = String.valueOf(dialog) + "\r\n";
                        dialog = String.valueOf(dialog) + "\r\n";
                        dialog = String.valueOf(dialog) + "        Type: " + UserIO.throwableDescription(t);
                        if (t.getMessage() != null) {
                            dialog = String.valueOf(dialog) + "\r\n";
                            dialog = String.valueOf(dialog) + "        Message: " + t.getMessage();
                        }
                        if (t.getCause() != null) {
                            dialog = String.valueOf(dialog) + "\r\n";
                            dialog = String.valueOf(dialog) + "        Cause: " + UserIO.throwableDescription(t.getCause());
                        }
                        dialog = String.valueOf(dialog) + "\r\n";
                        dialog = String.valueOf(dialog) + "\r\n";
                        dialog = String.valueOf(dialog) + "Unfortunately the program must be terminated.";
                        Frame[] roots = Frame.getFrames();
                        Frame root = null;
                        if (roots != null && roots.length != 0) {
                            root = roots[0];
                        }
                        UserIO.alert(root, String.valueOf(appName) + " :: Fatal Error", dialog);
                        System.exit(0);
                    }
                }
            });
            crashThread.setDaemon(true);
            crashThread.start();
        }
    }
}

