/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.misc.gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

public class GraphicsUtil {
    private static final Map<Graphics2D, LinkedList<AffineTransform>> gra2traList = new HashMap<Graphics2D, LinkedList<AffineTransform>>();

    public static void pushTransform(Graphics2D g) {
        LinkedList<AffineTransform> traList = gra2traList.get(g);
        if (traList == null) {
            traList = new LinkedList();
            gra2traList.put(g, traList);
        }
        traList.addFirst(g.getTransform());
    }

    public static void popTransform(Graphics2D g) {
        LinkedList<AffineTransform> traList = gra2traList.get(g);
        if (traList == null || traList.isEmpty()) {
            throw new NoSuchElementException();
        }
        g.setTransform(traList.removeFirst());
    }

    public static final void disableAA(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static final void enableAA(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static final void enableHQ(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }
}

