/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.misc;

import craterstudio.math.EasyMath;
import java.awt.Color;

public class ColorHSL {
    public static final float RED_HUE = ColorHSL.fromColor(Color.RED)[0];
    public static final float ORANGE_HUE = ColorHSL.fromColor(Color.ORANGE)[0];
    public static final float YELLOW_HUE = ColorHSL.fromColor(Color.YELLOW)[0];
    public static final float GREEN_HUE = ColorHSL.fromColor(Color.GREEN)[0];
    public static final float CYAN_HUE = ColorHSL.fromColor(Color.CYAN)[0];
    public static final float BLUE_HUE = ColorHSL.fromColor(Color.BLUE)[0];
    public static final float PURPLE_HUE = ColorHSL.fromColor(new Color(255, 0, 255))[0];

    public static final float[] fromColor(Color color) {
        return ColorHSL.fromColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static final float[] fromColor(int r, int g, int b) {
        int[] rgb = new int[]{r, g, b};
        float[] hsl = new float[3];
        ColorHSL.rgb2hsl(rgb, hsl);
        return hsl;
    }

    public static final Color toColor(float[] hsl) {
        int[] rgb = new int[3];
        ColorHSL.hsl2rgb(hsl, rgb);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static final Color toColor(float h, float s, float l) {
        return ColorHSL.toColor(new float[]{h, s, l});
    }

    public static final Color lerp(float t, Color a, Color b) {
        int[] aRGB = new int[3];
        int[] bRGB = new int[3];
        aRGB[0] = a.getRed();
        aRGB[1] = a.getGreen();
        aRGB[2] = a.getBlue();
        bRGB[0] = b.getRed();
        bRGB[1] = b.getGreen();
        bRGB[2] = b.getBlue();
        float[] aHSL = new float[3];
        float[] bHSL = new float[3];
        ColorHSL.rgb2hsl(aRGB, aHSL);
        ColorHSL.rgb2hsl(bRGB, bHSL);
        float[] cHSL = new float[]{EasyMath.lerp(t, aHSL[0], bHSL[0]), EasyMath.lerp(t, aHSL[1], bHSL[1]), EasyMath.lerp(t, aHSL[2], bHSL[2])};
        int[] cRGB = new int[3];
        ColorHSL.hsl2rgb(cHSL, cRGB);
        return new Color(cRGB[0], cRGB[1], cRGB[2]);
    }

    public static final Color setBrightness(Color c, float delta) {
        int[] RGB = new int[3];
        float[] HSL = new float[3];
        RGB[0] = c.getRed();
        RGB[1] = c.getGreen();
        RGB[2] = c.getBlue();
        ColorHSL.rgb2hsl(RGB, HSL);
        HSL[2] = delta;
        ColorHSL.hsl2rgb(HSL, RGB);
        return new Color(RGB[0], RGB[1], RGB[2]);
    }

    public static final Color adjust(Color c, float hue, float sat, float lig) {
        int[] RGB = new int[3];
        float[] HSL = new float[3];
        RGB[0] = c.getRed();
        RGB[1] = c.getGreen();
        RGB[2] = c.getBlue();
        ColorHSL.rgb2hsl(RGB, HSL);
        HSL[0] = HSL[0] + hue;
        HSL[1] = HSL[1] + sat;
        HSL[2] = HSL[2] + lig;
        ColorHSL.hsl2rgb(HSL, RGB);
        return new Color(RGB[0], RGB[1], RGB[2]);
    }

    public static final Color adjustHue(Color c, float delta) {
        int[] RGB = new int[3];
        float[] HSL = new float[3];
        RGB[0] = c.getRed();
        RGB[1] = c.getGreen();
        RGB[2] = c.getBlue();
        ColorHSL.rgb2hsl(RGB, HSL);
        HSL[0] = HSL[0] + delta;
        ColorHSL.hsl2rgb(HSL, RGB);
        return new Color(RGB[0], RGB[1], RGB[2]);
    }

    public static final Color adjustBrightness(Color c, float delta) {
        int[] RGB = new int[3];
        float[] HSL = new float[3];
        RGB[0] = c.getRed();
        RGB[1] = c.getGreen();
        RGB[2] = c.getBlue();
        ColorHSL.rgb2hsl(RGB, HSL);
        HSL[2] = HSL[2] + delta;
        ColorHSL.hsl2rgb(HSL, RGB);
        return new Color(RGB[0], RGB[1], RGB[2]);
    }

    public static final int[] rgb2arr(int rgb) {
        int[] arr = new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb >> 0 & 0xFF};
        return arr;
    }

    public static final int arr2rgb(int[] arr) {
        int rgb = 0;
        rgb |= (arr[0] & 0xFF) << 16;
        rgb |= (arr[1] & 0xFF) << 8;
        return rgb |= (arr[2] & 0xFF) << 0;
    }

    public static final void rgb2hsl(int[] rgb, float[] hsl) {
        float R = (float)rgb[0] / 255.0f;
        float G = (float)rgb[1] / 255.0f;
        float B = (float)rgb[2] / 255.0f;
        float MAX = Math.max(R, Math.max(G, B));
        float MIN = Math.min(R, Math.min(G, B));
        float H = MIN == MAX ? 0.0f : (R == MAX ? 0.16666666f * ((G - B) / (MAX - MIN)) + 0.0f : (G == MAX ? 0.16666666f * ((B - R) / (MAX - MIN)) + 0.33333334f : 0.16666666f * ((R - G) / (MAX - MIN)) + 0.6666667f));
        float L = 0.5f * (MIN + MAX);
        float S = L == 0.0f || MIN == MAX ? 0.0f : (L <= 0.5f ? (MAX - MIN) / (2.0f * L) : (MAX - MIN) / (2.0f - 2.0f * L));
        hsl[0] = ColorHSL.absMod(H, 1.0f);
        hsl[1] = S;
        hsl[2] = L;
    }

    public static final int[] hsl2rgb(float[] hsl, int[] rgb) {
        float R;
        float G;
        float B;
        float H = hsl[0];
        float S = hsl[1];
        float L = hsl[2];
        if (S == 0.0f) {
            G = B = L;
            R = B;
        } else {
            float Q = L < 0.5f ? L * (1.0f + S) : L + S - L * S;
            float P = 2.0f * L - Q;
            float Hk = ColorHSL.absMod(H, 1.0f);
            R = ColorHSL.convert(Q, P, Hk + 0.33333334f);
            G = ColorHSL.convert(Q, P, Hk + 0.0f);
            B = ColorHSL.convert(Q, P, Hk - 0.33333334f);
        }
        rgb[0] = (int)(ColorHSL.clamp(R, 0.0f, 1.0f) * 255.0f);
        rgb[1] = (int)(ColorHSL.clamp(G, 0.0f, 1.0f) * 255.0f);
        rgb[2] = (int)(ColorHSL.clamp(B, 0.0f, 1.0f) * 255.0f);
        return rgb;
    }

    private static final float convert(float Q, float P, float Tx) {
        if ((Tx = ColorHSL.absMod(Tx, 1.0f)) < 0.16666667f) {
            return P + (Q - P) * 6.0f * Tx;
        }
        if (Tx < 0.5f) {
            return Q;
        }
        if (Tx < 0.6666667f) {
            return P + (Q - P) * 6.0f * (0.6666667f - Tx);
        }
        return P;
    }

    public static final float absMod(float val, float max) {
        return (val % max + max) % max;
    }

    public static final float clamp(float cur, float min, float max) {
        if (cur < min) {
            return min;
        }
        if (cur > max) {
            return max;
        }
        return cur;
    }
}

