/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.math;

import craterstudio.math.FastMath;
import craterstudio.math.Matrix4;
import craterstudio.math.Sphere;
import craterstudio.math.Vec2;
import craterstudio.math.Vec3;
import craterstudio.math.Vec4;

public class VecMath {
    private static final Vec3 q = new Vec3();
    private static final Vec3 p = new Vec3();

    public static Vec2 add(Vec2 a, Vec2 b) {
        return new Vec2().load(a).add(b);
    }

    public static Vec2 sub(Vec2 a, Vec2 b) {
        return new Vec2().load(a).sub(b);
    }

    public static Vec2 mul(Vec2 a, Vec2 b) {
        return new Vec2().load(a).mul(b);
    }

    public static Vec2 div(Vec2 a, Vec2 b) {
        return new Vec2().load(a).div(b);
    }

    public static Vec3 add(Vec3 a, Vec3 b) {
        return new Vec3().load(a).add(b);
    }

    public static Vec3 sub(Vec3 a, Vec3 b) {
        return new Vec3().load(a).sub(b);
    }

    public static Vec3 mul(Vec3 a, Vec3 b) {
        return new Vec3().load(a).mul(b);
    }

    public static Vec3 div(Vec3 a, Vec3 b) {
        return new Vec3().load(a).div(b);
    }

    public static final Vec3 min(Vec3 vector, Vec3 compare) {
        if (compare.x() < vector.x()) {
            vector.x(compare.x());
        }
        if (compare.y() < vector.y()) {
            vector.y(compare.y());
        }
        if (compare.z() < vector.z()) {
            vector.z(compare.z());
        }
        return vector;
    }

    public static final Vec3 max(Vec3 vector, Vec3 compare) {
        if (compare.x() > vector.x()) {
            vector.x(compare.x());
        }
        if (compare.y() > vector.y()) {
            vector.y(compare.y());
        }
        if (compare.z() > vector.z()) {
            vector.z(compare.z());
        }
        return vector;
    }

    public static final Vec3 clamp(Vec3 vector, Vec3 min, Vec3 max) {
        if (vector.x() > max.x()) {
            vector.x(max.x());
        } else if (vector.x() < min.x()) {
            vector.x(min.x());
        }
        if (vector.y() > max.y()) {
            vector.y(max.y());
        } else if (vector.y() < min.y()) {
            vector.y(min.y());
        }
        if (vector.z() > max.z()) {
            vector.z(max.z());
        } else if (vector.z() < min.z()) {
            vector.z(min.z());
        }
        return vector;
    }

    public static final Vec3 normal(Vec3 a, Vec3 b, Vec3 c) {
        return VecMath.normal(a, b, c, new Vec3());
    }

    public static final Vec3 normal(Vec3 a, Vec3 b, Vec3 c, Vec3 r) {
        q.load(b.x() - a.x(), b.y() - a.y(), b.z() - a.z());
        p.load(c.x() - a.x(), c.y() - a.y(), c.z() - a.z());
        return VecMath.cross(q, p, r).normalize();
    }

    public static float dot(Vec3 a, Vec3 b) {
        return a.x() * b.x() + a.y() * b.y() + a.z() * b.z();
    }

    public static Vec3 cross(Vec3 a, Vec3 b) {
        return VecMath.cross(a, b, new Vec3());
    }

    public static Vec3 cross(Vec3 a, Vec3 b, Vec3 r) {
        r.x(a.y() * b.z() - a.z() * b.y());
        r.y(a.z() * b.x() - a.x() * b.z());
        r.z(a.x() * b.y() - a.y() * b.x());
        return r;
    }

    public static final float angleToFlat3D(Vec3 a, Vec3 b) {
        return FastMath.atan2Deg(b.z() - a.z(), b.x() - a.x());
    }

    public static final float angleToVertical3D(Vec3 a, Vec3 b) {
        return FastMath.atan2Deg(b.y() - a.y(), VecMath.distanceFlat(a, b));
    }

    public static final float angleToFlat3DStrict(Vec3 a, Vec3 b) {
        return (float)(Math.atan2(b.z() - a.z(), b.x() - a.x()) * 180.0 / Math.PI);
    }

    public static final float angleToVertical3DStrict(Vec3 a, Vec3 b) {
        return (float)(Math.atan2(b.y() - a.y(), VecMath.distanceFlat(a, b)) * 180.0 / Math.PI);
    }

    public static final float distance(Vec3 a, Vec3 b) {
        float x = a.x() - b.x();
        float y = a.y() - b.y();
        float z = a.z() - b.z();
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public static final float distanceFlat(Vec3 a, Vec3 b) {
        float x = a.x() - b.x();
        float z = a.z() - b.z();
        return (float)Math.sqrt(x * x + z * z);
    }

    public static final float squaredDistance(Vec3 a, Vec3 b) {
        float x = a.x() - b.x();
        float y = a.y() - b.y();
        float z = a.z() - b.z();
        return x * x + y * y + z * z;
    }

    public static final float squaredDistanceFlat(Vec3 a, Vec3 b) {
        float x = a.x() - b.x();
        float z = a.z() - b.z();
        return x * x + z * z;
    }

    public static final boolean isInRange(Sphere a, Sphere b) {
        return VecMath.isInRange(a.origin, b.origin, a.radius + b.radius);
    }

    public static final boolean isInRange(Vec3 a, Vec3 b, float d) {
        float x = a.x - b.x;
        float y = a.y - b.y;
        float z = a.z - b.z;
        return x * x + y * y + z * z < d * d;
    }

    public static final boolean isInRangeFlat(Vec3 a, Vec3 b, float d) {
        float x = a.x - b.x;
        float z = a.z - b.z;
        return x * x + z * z < d * d;
    }

    public static final Vec2 lerp(float t, Vec2 a, Vec2 b) {
        return VecMath.lerp(t, a, b, new Vec2());
    }

    public static final Vec3 lerp(float t, Vec3 a, Vec3 b) {
        return VecMath.lerp(t, a, b, new Vec3());
    }

    public static final Vec4 lerp(float t, Vec4 a, Vec4 b) {
        return VecMath.lerp(t, a, b, new Vec4());
    }

    public static final Vec2 lerp(float t, Vec2 a, Vec2 b, Vec2 r) {
        r.x(a.x() + t * (b.x() - a.x()));
        r.y(a.y() + t * (b.y() - a.y()));
        return r;
    }

    public static final Vec3 lerp(float t, Vec3 a, Vec3 b, Vec3 r) {
        r.x(a.x() + t * (b.x() - a.x()));
        r.y(a.y() + t * (b.y() - a.y()));
        r.z(a.z() + t * (b.z() - a.z()));
        return r;
    }

    public static final Vec4 lerp(float t, Vec4 a, Vec4 b, Vec4 r) {
        r.x(a.x() + t * (b.x() - a.x()));
        r.y(a.y() + t * (b.y() - a.y()));
        r.z(a.z() + t * (b.z() - a.z()));
        r.w(a.w() + t * (b.w() - a.w()));
        return r;
    }

    public static final void quatToMatrix(Vec4 quat, Matrix4 mat) {
        float x = quat.x;
        float y = quat.y;
        float z = quat.z;
        float w = quat.w;
        float x2 = x * x;
        float y2 = y * y;
        float z2 = z * z;
        Vec4 v4 = new Vec4();
        mat.setRow(0, v4.load(1.0f - 2.0f * (y2 - z2), 2.0f * (x * y - w * z), 2.0f * (x * z + w * y), 0.0f));
        mat.setRow(1, v4.load(2.0f * (x * y + w * z), 1.0f - 2.0f * (x2 - z2), 2.0f * (y * z - w * x), 0.0f));
        mat.setRow(2, v4.load(2.0f * (x * z - w * y), 2.0f * (y * z + w * x), 1.0f - 2.0f * (x2 - y2), 0.0f));
        mat.setRow(3, v4.load(0.0f, 0.0f, 0.0f, 1.0f));
    }

    public static final Vec4 quatToAxisAngle_(Vec4 quat, Vec4 axis) {
        float W;
        float X = quat.x;
        float Y = quat.y;
        float Z = quat.z;
        float cos_a = W = quat.w;
        float angle = (float)Math.acos(cos_a) * 2.0f;
        float sin_a = (float)Math.sqrt(1.0f - cos_a * cos_a);
        if (sin_a < 5.0E-4f) {
            sin_a = 1.0f;
        }
        axis.x = X / sin_a;
        axis.y = Y / sin_a;
        axis.z = Z / sin_a;
        axis.w = angle * 180.0f / 3.1415f;
        return axis;
    }

    public static final Vec4 quatToAxisAngle(Vec4 quat, Vec4 axis) {
        float X = quat.x;
        float Y = quat.y;
        float Z = quat.z;
        float s = X * X + Y * Y + Z * Z;
        axis.x = X / s;
        axis.y = Y / s;
        axis.z = Z / s;
        axis.w = (float)Math.toDegrees(2.0 * Math.acos(quat.w));
        return axis;
    }

    public static final Vec4 axisAngleToQuat(Vec4 axis, Vec4 quat) {
        float halfAngle = axis.w / 180.0f * 3.1415f;
        float sin_a = (float)Math.sin(halfAngle);
        float cos_a = (float)Math.cos(halfAngle);
        quat.x = axis.x * sin_a;
        quat.y = axis.y * sin_a;
        quat.z = axis.z * sin_a;
        quat.w = cos_a;
        return quat;
    }
}

