/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.math;

import craterstudio.math.EasyMath;
import craterstudio.text.TextValues;
import java.nio.FloatBuffer;

public class Vec4 {
    public float x;
    public float y;
    public float z;
    public float w;

    public final float x() {
        return this.x;
    }

    public final float y() {
        return this.y;
    }

    public final float z() {
        return this.z;
    }

    public final float w() {
        return this.w;
    }

    public final void x(float x) {
        this.x = x;
    }

    public final void y(float y) {
        this.y = y;
    }

    public final void z(float z) {
        this.z = z;
    }

    public final void w(float w) {
        this.w = w;
    }

    public Vec4() {
        this.load(0.0f);
    }

    public Vec4(float xyzw) {
        this.load(xyzw);
    }

    public Vec4(float x, float y, float z, float w) {
        this.load(x, y, z, w);
    }

    public Vec4(float[] v, int pos) {
        this.load(v, pos);
    }

    public Vec4(Vec4 v) {
        this.load(v);
    }

    public Vec4 load(Vec4 v) {
        this.x(v.x());
        this.y(v.y());
        this.z(v.z());
        this.w(v.w());
        return this;
    }

    public Vec4 load(float val) {
        this.x(val);
        this.y(val);
        this.z(val);
        this.w(val);
        return this;
    }

    public Vec4 load(float x, float y, float z, float w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public Vec4 load(float[] arr, int pos) {
        this.x(arr[pos + 0]);
        this.y(arr[pos + 1]);
        this.z(arr[pos + 2]);
        this.w(arr[pos + 3]);
        return this;
    }

    public Vec4 load(FloatBuffer buf) {
        this.x(buf.get());
        this.y(buf.get());
        this.z(buf.get());
        this.w(buf.get());
        return this;
    }

    public Vec4 load(FloatBuffer buf, int pos) {
        this.x(buf.get(pos + 0));
        this.y(buf.get(pos + 1));
        this.z(buf.get(pos + 2));
        this.w(buf.get(pos + 3));
        return this;
    }

    public final void store(float[] arr, int off) {
        arr[off + 0] = this.x();
        arr[off + 1] = this.y();
        arr[off + 2] = this.z();
        arr[off + 3] = this.w();
    }

    public final void store(FloatBuffer buf) {
        buf.put(this.x());
        buf.put(this.y());
        buf.put(this.z());
        buf.put(this.w());
    }

    public final void store(FloatBuffer buf, int pos) {
        buf.put(pos + 0, this.x());
        buf.put(pos + 1, this.y());
        buf.put(pos + 2, this.z());
        buf.put(pos + 3, this.w());
    }

    public float squaredLength() {
        return this.x() * this.x() + this.y() * this.y() + this.z() * this.z() + this.w() * this.w();
    }

    public float length() {
        return (float)Math.sqrt(this.squaredLength());
    }

    public Vec4 length(float val) {
        float li = val / (float)Math.sqrt(this.squaredLength());
        this.x(this.x() * li);
        this.y(this.y() * li);
        this.z(this.z() * li);
        this.w(this.w() * li);
        return this;
    }

    public Vec4 normalize() {
        float li = 1.0f / (float)Math.sqrt(this.squaredLength());
        this.x(this.x() * li);
        this.y(this.y() * li);
        this.z(this.z() * li);
        this.w(this.w() * li);
        return this;
    }

    public Vec4 inv() {
        this.x(-this.x());
        this.y(-this.y());
        this.z(-this.z());
        this.w(-this.w());
        return this;
    }

    public Vec4 abs() {
        if (this.x() < 0.0f) {
            this.x(-this.x());
        }
        if (this.y() < 0.0f) {
            this.y(-this.y());
        }
        if (this.z() < 0.0f) {
            this.z(-this.z());
        }
        if (this.w() < 0.0f) {
            this.w(-this.w());
        }
        return this;
    }

    public Vec4 add(float x, float y, float z, float w) {
        this.x(this.x() + x);
        this.y(this.y() + y);
        this.z(this.z() + z);
        this.w(this.w() + w);
        return this;
    }

    public Vec4 sub(float x, float y, float z, float w) {
        this.x(this.x() - x);
        this.y(this.y() - y);
        this.z(this.z() - z);
        this.w(this.w() - w);
        return this;
    }

    public Vec4 mul(float x, float y, float z, float w) {
        this.x(this.x() * x);
        this.y(this.y() * y);
        this.z(this.z() * z);
        this.w(this.w() * w);
        return this;
    }

    public Vec4 div(float x, float y, float z, float w) {
        this.x(this.x() / x);
        this.y(this.y() / y);
        this.z(this.z() / z);
        this.w(this.w() / w);
        return this;
    }

    public Vec4 add(float xyzw) {
        return this.add(xyzw, xyzw, xyzw, xyzw);
    }

    public Vec4 sub(float xyzw) {
        return this.sub(xyzw, xyzw, xyzw, xyzw);
    }

    public Vec4 mul(float xyzw) {
        return this.mul(xyzw, xyzw, xyzw, xyzw);
    }

    public Vec4 div(float xyzw) {
        return this.div(xyzw, xyzw, xyzw, xyzw);
    }

    public Vec4 add(Vec4 vec) {
        return this.add(vec.x(), vec.y(), vec.z(), vec.w());
    }

    public Vec4 sub(Vec4 vec) {
        return this.sub(vec.x(), vec.y(), vec.z(), vec.w());
    }

    public Vec4 mul(Vec4 vec) {
        return this.mul(vec.x(), vec.y(), vec.z(), vec.w());
    }

    public Vec4 div(Vec4 vec) {
        return this.div(vec.x(), vec.y(), vec.z(), vec.w());
    }

    public Vec4 min(Vec4 vec) {
        if (vec.x() < this.x()) {
            this.x(vec.x());
        }
        if (vec.y() < this.y()) {
            this.y(vec.y());
        }
        if (vec.z() < this.z()) {
            this.z(vec.z());
        }
        if (vec.w() < this.w()) {
            this.w(vec.w());
        }
        return this;
    }

    public Vec4 max(Vec4 vec) {
        if (vec.x() > this.x()) {
            this.x(vec.x());
        }
        if (vec.y() > this.y()) {
            this.y(vec.y());
        }
        if (vec.z() > this.z()) {
            this.z(vec.z());
        }
        if (vec.w() > this.w()) {
            this.w(vec.w());
        }
        return this;
    }

    public boolean equals(Vec4 vec, float margin) {
        boolean bX = EasyMath.equals(this.x(), vec.x(), margin);
        boolean bY = EasyMath.equals(this.y(), vec.y(), margin);
        boolean bZ = EasyMath.equals(this.z(), vec.z(), margin);
        boolean bW = EasyMath.equals(this.w(), vec.w(), margin);
        return bX && bY && bZ && bW;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Vec4)) {
            return false;
        }
        return this.equals((Vec4)obj, 0.001f);
    }

    public int hashCode() {
        int xi = (int)(this.x() * 1000.0f);
        int yi = (int)(this.y() * 1000.0f);
        int zi = (int)(this.z() * 1000.0f);
        int wi = (int)(this.w() * 1000.0f);
        return xi ^ yi ^ zi ^ wi;
    }

    public String toString() {
        String sX = Float.isNaN(this.x()) ? "NaN" : TextValues.formatNumber((double)this.x(), (int)3);
        String sY = Float.isNaN(this.y()) ? "NaN" : TextValues.formatNumber((double)this.y(), (int)3);
        String sZ = Float.isNaN(this.z()) ? "NaN" : TextValues.formatNumber((double)this.z(), (int)3);
        String sW = Float.isNaN(this.w()) ? "NaN" : TextValues.formatNumber((double)this.w(), (int)3);
        return "Vec3[" + sX + ", " + sY + ", " + sZ + ", " + sW + "]";
    }
}

