/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.math;

import craterstudio.math.EasyMath;
import craterstudio.text.TextValues;
import java.nio.FloatBuffer;

public class Vec3 {
    public float x;
    public float y;
    public float z;

    public final float x() {
        return this.x;
    }

    public final float y() {
        return this.y;
    }

    public final float z() {
        return this.z;
    }

    public final void x(float x) {
        this.x = x;
    }

    public final void y(float y) {
        this.y = y;
    }

    public final void z(float z) {
        this.z = z;
    }

    public Vec3() {
        this.load(0.0f);
    }

    public Vec3(float xyz) {
        this.load(xyz);
    }

    public Vec3(float x, float y, float z) {
        this.load(x, y, z);
    }

    public Vec3(float[] v, int pos) {
        this.load(v, pos);
    }

    public Vec3(Vec3 v) {
        this.load(v);
    }

    public Vec3 load(Vec3 v) {
        this.x(v.x());
        this.y(v.y());
        this.z(v.z());
        return this;
    }

    public Vec3 load(float val) {
        this.x(val);
        this.y(val);
        this.z(val);
        return this;
    }

    public Vec3 load(float x, float y, float z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public Vec3 load(float[] arr, int pos) {
        this.x(arr[pos + 0]);
        this.y(arr[pos + 1]);
        this.z(arr[pos + 2]);
        return this;
    }

    public Vec3 load(FloatBuffer buf) {
        this.x(buf.get());
        this.y(buf.get());
        this.z(buf.get());
        return this;
    }

    public Vec3 load(FloatBuffer buf, int pos) {
        this.x(buf.get(pos + 0));
        this.y(buf.get(pos + 1));
        this.z(buf.get(pos + 2));
        return this;
    }

    public final float[] store(float[] arr, int off) {
        arr[off + 0] = this.x();
        arr[off + 1] = this.y();
        arr[off + 2] = this.z();
        return arr;
    }

    public final void store(FloatBuffer buf) {
        buf.put(this.x());
        buf.put(this.y());
        buf.put(this.z());
    }

    public final void store(FloatBuffer buf, int pos) {
        buf.put(pos + 0, this.x());
        buf.put(pos + 1, this.y());
        buf.put(pos + 2, this.z());
    }

    public float squaredLength() {
        return this.x() * this.x() + this.y() * this.y() + this.z() * this.z();
    }

    public float length() {
        return (float)Math.sqrt(this.squaredLength());
    }

    public Vec3 length(float val) {
        float li = val / (float)Math.sqrt(this.squaredLength());
        this.x(this.x() * li);
        this.y(this.y() * li);
        this.z(this.z() * li);
        return this;
    }

    public Vec3 normalize() {
        float li = 1.0f / (float)Math.sqrt(this.squaredLength());
        this.x(this.x() * li);
        this.y(this.y() * li);
        this.z(this.z() * li);
        return this;
    }

    public Vec3 inv() {
        this.x(-this.x());
        this.y(-this.y());
        this.z(-this.z());
        return this;
    }

    public Vec3 abs() {
        if (this.x() < 0.0f) {
            this.x(-this.x());
        }
        if (this.y() < 0.0f) {
            this.y(-this.y());
        }
        if (this.z() < 0.0f) {
            this.z(-this.z());
        }
        return this;
    }

    public Vec3 add(float x, float y, float z) {
        this.x(this.x() + x);
        this.y(this.y() + y);
        this.z(this.z() + z);
        return this;
    }

    public Vec3 sub(float x, float y, float z) {
        this.x(this.x() - x);
        this.y(this.y() - y);
        this.z(this.z() - z);
        return this;
    }

    public Vec3 mul(float x, float y, float z) {
        this.x(this.x() * x);
        this.y(this.y() * y);
        this.z(this.z() * z);
        return this;
    }

    public Vec3 div(float x, float y, float z) {
        this.x(this.x() / x);
        this.y(this.y() / y);
        this.z(this.z() / z);
        return this;
    }

    public Vec3 add(float xyz) {
        return this.add(xyz, xyz, xyz);
    }

    public Vec3 sub(float xyz) {
        return this.sub(xyz, xyz, xyz);
    }

    public Vec3 mul(float xyz) {
        return this.mul(xyz, xyz, xyz);
    }

    public Vec3 div(float xyz) {
        return this.div(xyz, xyz, xyz);
    }

    public Vec3 add(Vec3 vec) {
        return this.add(vec.x(), vec.y(), vec.z());
    }

    public Vec3 sub(Vec3 vec) {
        return this.sub(vec.x(), vec.y(), vec.z());
    }

    public Vec3 mul(Vec3 vec) {
        return this.mul(vec.x(), vec.y(), vec.z());
    }

    public Vec3 div(Vec3 vec) {
        return this.div(vec.x(), vec.y(), vec.z());
    }

    public Vec3 min(Vec3 vec) {
        if (vec.x() < this.x()) {
            this.x(vec.x());
        }
        if (vec.y() < this.y()) {
            this.y(vec.y());
        }
        if (vec.z() < this.z()) {
            this.z(vec.z());
        }
        return this;
    }

    public Vec3 max(Vec3 vec) {
        if (vec.x() > this.x()) {
            this.x(vec.x());
        }
        if (vec.y() > this.y()) {
            this.y(vec.y());
        }
        if (vec.z() > this.z()) {
            this.z(vec.z());
        }
        return this;
    }

    public boolean equals(Vec3 vec, float margin) {
        boolean bX = EasyMath.equals(this.x(), vec.x(), margin);
        boolean bY = EasyMath.equals(this.y(), vec.y(), margin);
        boolean bZ = EasyMath.equals(this.z(), vec.z(), margin);
        return bX && bY && bZ;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Vec3)) {
            return false;
        }
        return this.equals((Vec3)obj, 0.001f);
    }

    public int hashCode() {
        int xi = (int)(this.x() * 1000.0f);
        int yi = (int)(this.y() * 1000.0f);
        int zi = (int)(this.z() * 1000.0f);
        return xi ^ yi ^ zi;
    }

    public String toString() {
        String sX = Float.isNaN(this.x()) ? "NaN" : TextValues.formatNumber((double)this.x(), (int)3);
        String sY = Float.isNaN(this.y()) ? "NaN" : TextValues.formatNumber((double)this.y(), (int)3);
        String sZ = Float.isNaN(this.z()) ? "NaN" : TextValues.formatNumber((double)this.z(), (int)3);
        return "Vec3[" + sX + ", " + sY + ", " + sZ + "]";
    }
}

