/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.math;

import craterstudio.math.EasyMath;
import craterstudio.text.TextValues;
import java.nio.FloatBuffer;

public class Vec2 {
    public float x;
    public float y;

    public final float x() {
        return this.x;
    }

    public final float y() {
        return this.y;
    }

    public final void x(float x) {
        this.x = x;
    }

    public final void y(float y) {
        this.y = y;
    }

    public Vec2() {
        this.load(0.0f);
    }

    public Vec2(float xy) {
        this.load(xy);
    }

    public Vec2(float x, float y) {
        this.load(x, y);
    }

    public Vec2(float[] v, int pos) {
        this.load(v, pos);
    }

    public Vec2(Vec2 v) {
        this.load(v);
    }

    public Vec2 load(Vec2 v) {
        this.x(v.x());
        this.y(v.y());
        return this;
    }

    public Vec2 load(float val) {
        this.x(val);
        this.y(val);
        return this;
    }

    public Vec2 load(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public Vec2 load(float[] arr, int pos) {
        this.x(arr[pos + 0]);
        this.y(arr[pos + 1]);
        return this;
    }

    public Vec2 load(FloatBuffer buf) {
        this.x(buf.get());
        this.y(buf.get());
        return this;
    }

    public Vec2 load(FloatBuffer buf, int pos) {
        this.x(buf.get(pos + 0));
        this.y(buf.get(pos + 1));
        return this;
    }

    public final void store(float[] arr, int off) {
        arr[off + 0] = this.x();
        arr[off + 1] = this.y();
    }

    public final void store(FloatBuffer buf) {
        buf.put(this.x());
        buf.put(this.y());
    }

    public final void store(FloatBuffer buf, int pos) {
        buf.put(pos + 0, this.x());
        buf.put(pos + 1, this.y());
    }

    public float squaredLength() {
        return this.x() * this.x() + this.y() * this.y();
    }

    public float length() {
        return (float)Math.sqrt(this.squaredLength());
    }

    public Vec2 length(float val) {
        float li = val / (float)Math.sqrt(this.squaredLength());
        this.x(this.x() * li);
        this.y(this.y() * li);
        return this;
    }

    public Vec2 normalize() {
        float li = 1.0f / (float)Math.sqrt(this.squaredLength());
        this.x(this.x() * li);
        this.y(this.y() * li);
        return this;
    }

    public Vec2 inv() {
        this.x(-this.x());
        this.y(-this.y());
        return this;
    }

    public Vec2 abs() {
        if (this.x() < 0.0f) {
            this.x(-this.x());
        }
        if (this.y() < 0.0f) {
            this.y(-this.y());
        }
        return this;
    }

    public Vec2 add(float x, float y) {
        this.x(this.x() + x);
        this.y(this.y() + y);
        return this;
    }

    public Vec2 sub(float x, float y) {
        this.x(this.x() - x);
        this.y(this.y() - y);
        return this;
    }

    public Vec2 mul(float x, float y) {
        this.x(this.x() * x);
        this.y(this.y() * y);
        return this;
    }

    public Vec2 div(float x, float y) {
        this.x(this.x() / x);
        this.y(this.y() / y);
        return this;
    }

    public Vec2 add(float xy) {
        return this.add(xy, xy);
    }

    public Vec2 sub(float xy) {
        return this.sub(xy, xy);
    }

    public Vec2 mul(float xy) {
        return this.mul(xy, xy);
    }

    public Vec2 div(float xy) {
        return this.div(xy, xy);
    }

    public Vec2 add(Vec2 vec) {
        return this.add(vec.x(), vec.y());
    }

    public Vec2 sub(Vec2 vec) {
        return this.sub(vec.x(), vec.y());
    }

    public Vec2 mul(Vec2 vec) {
        return this.mul(vec.x(), vec.y());
    }

    public Vec2 div(Vec2 vec) {
        return this.div(vec.x(), vec.y());
    }

    public Vec2 min(Vec2 vec) {
        if (vec.x() < this.x()) {
            this.x(vec.x());
        }
        if (vec.y() < this.y()) {
            this.y(vec.y());
        }
        return this;
    }

    public Vec2 max(Vec2 vec) {
        if (vec.x() > this.x()) {
            this.x(vec.x());
        }
        if (vec.y() > this.y()) {
            this.y(vec.y());
        }
        return this;
    }

    public boolean equals(Vec2 vec, float margin) {
        boolean bX = EasyMath.equals(this.x(), vec.x(), margin);
        boolean bY = EasyMath.equals(this.y(), vec.y(), margin);
        return bX && bY;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Vec2)) {
            return false;
        }
        return this.equals((Vec2)obj, 0.001f);
    }

    public int hashCode() {
        int xi = (int)(this.x() * 1000.0f);
        int yi = (int)(this.y() * 1000.0f);
        return xi ^ yi;
    }

    public String toString() {
        String sX = Float.isNaN(this.x()) ? "NaN" : TextValues.formatNumber((double)this.x(), (int)3);
        String sY = Float.isNaN(this.y()) ? "NaN" : TextValues.formatNumber((double)this.y(), (int)3);
        return "Vec2[" + sX + ", " + sY + "]";
    }
}

