/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.math;

import craterstudio.math.EasyMath;
import craterstudio.math.FastMath;
import craterstudio.math.Vec3;
import craterstudio.math.Vec4;
import craterstudio.text.TextValues;
import java.nio.FloatBuffer;

public class Matrix4 {
    public float m00 = 1.0f;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11 = 1.0f;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22 = 1.0f;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33 = 1.0f;

    public final Vec3 transform(Vec3 src_dst) {
        return this.transform(src_dst, src_dst);
    }

    public final Vec3 transform(Vec3 src, Vec3 dst) {
        float x = src.x();
        float y = src.y();
        float z = src.z();
        dst.x(this.m00 * x + this.m01 * y + this.m02 * z + this.m03);
        dst.y(this.m10 * x + this.m11 * y + this.m12 * z + this.m13);
        dst.z(this.m20 * x + this.m21 * y + this.m22 * z + this.m23);
        return dst;
    }

    public final void transform(Vec3[] src, Vec3[] dst) {
        int i = 0;
        while (i < src.length) {
            this.transform(src[i], dst[i]);
            ++i;
        }
    }

    public final void transform(FloatBuffer src, FloatBuffer dst) {
        this.transform(src, dst, 0, src.capacity() / 3);
    }

    public final void transform(FloatBuffer src, FloatBuffer dst, int off, int len) {
        float z;
        float y;
        float x;
        int c;
        int b;
        if (src.position() != 0 || src.limit() != src.capacity()) {
            throw new IllegalStateException("Src-floatbuffer must be cleared");
        }
        if (dst.position() != 0 || dst.limit() != dst.capacity()) {
            throw new IllegalStateException("Dst-floatbuffer must be cleared");
        }
        int a = off *= 3;
        int end = off + (len *= 3);
        int end4 = end / 3 / 4 * 4 * 3;
        while (a < end4) {
            b = a + 1;
            c = a + 2;
            x = src.get(a);
            y = src.get(b);
            z = src.get(c);
            dst.put(a, this.m00 * x + this.m01 * y + this.m02 * z + this.m03);
            dst.put(b, this.m10 * x + this.m11 * y + this.m12 * z + this.m13);
            dst.put(c, this.m20 * x + this.m21 * y + this.m22 * z + this.m23);
            b = (a += 3) + 1;
            c = a + 2;
            x = src.get(a);
            y = src.get(b);
            z = src.get(c);
            dst.put(a, this.m00 * x + this.m01 * y + this.m02 * z + this.m03);
            dst.put(b, this.m10 * x + this.m11 * y + this.m12 * z + this.m13);
            dst.put(c, this.m20 * x + this.m21 * y + this.m22 * z + this.m23);
            b = (a += 3) + 1;
            c = a + 2;
            x = src.get(a);
            y = src.get(b);
            z = src.get(c);
            dst.put(a, this.m00 * x + this.m01 * y + this.m02 * z + this.m03);
            dst.put(b, this.m10 * x + this.m11 * y + this.m12 * z + this.m13);
            dst.put(c, this.m20 * x + this.m21 * y + this.m22 * z + this.m23);
            b = (a += 3) + 1;
            c = a + 2;
            x = src.get(a);
            y = src.get(b);
            z = src.get(c);
            dst.put(a, this.m00 * x + this.m01 * y + this.m02 * z + this.m03);
            dst.put(b, this.m10 * x + this.m11 * y + this.m12 * z + this.m13);
            dst.put(c, this.m20 * x + this.m21 * y + this.m22 * z + this.m23);
            a += 3;
        }
        while (a < end) {
            b = a + 1;
            c = a + 2;
            x = src.get(a);
            y = src.get(b);
            z = src.get(c);
            dst.put(a, this.m00 * x + this.m01 * y + this.m02 * z + this.m03);
            dst.put(b, this.m10 * x + this.m11 * y + this.m12 * z + this.m13);
            dst.put(c, this.m20 * x + this.m21 * y + this.m22 * z + this.m23);
            a += 3;
        }
    }

    public final void transform(float[] src, float[] dst) {
        this.transform(src, dst, 0, src.length / 3);
    }

    public final void transform(float[] src, float[] dst, int off, int len) {
        float z;
        float y;
        float x;
        int c;
        int b;
        int a = off *= 3;
        int end = off + (len *= 3);
        int end4 = end / 3 / 4 * 4 * 3;
        while (a < end4) {
            b = a + 1;
            c = a + 2;
            x = src[a];
            y = src[b];
            z = src[c];
            dst[a] = this.m00 * x + this.m01 * y + this.m02 * z + this.m03;
            dst[b] = this.m10 * x + this.m11 * y + this.m12 * z + this.m13;
            dst[c] = this.m20 * x + this.m21 * y + this.m22 * z + this.m23;
            b = (a += 3) + 1;
            c = a + 2;
            x = src[a];
            y = src[b];
            z = src[c];
            dst[a] = this.m00 * x + this.m01 * y + this.m02 * z + this.m03;
            dst[b] = this.m10 * x + this.m11 * y + this.m12 * z + this.m13;
            dst[c] = this.m20 * x + this.m21 * y + this.m22 * z + this.m23;
            b = (a += 3) + 1;
            c = a + 2;
            x = src[a];
            y = src[b];
            z = src[c];
            dst[a] = this.m00 * x + this.m01 * y + this.m02 * z + this.m03;
            dst[b] = this.m10 * x + this.m11 * y + this.m12 * z + this.m13;
            dst[c] = this.m20 * x + this.m21 * y + this.m22 * z + this.m23;
            b = (a += 3) + 1;
            c = a + 2;
            x = src[a];
            y = src[b];
            z = src[c];
            dst[a] = this.m00 * x + this.m01 * y + this.m02 * z + this.m03;
            dst[b] = this.m10 * x + this.m11 * y + this.m12 * z + this.m13;
            dst[c] = this.m20 * x + this.m21 * y + this.m22 * z + this.m23;
            a += 3;
        }
        while (a < end) {
            b = a + 1;
            c = a + 2;
            x = src[a];
            y = src[b];
            z = src[c];
            dst[a] = this.m00 * x + this.m01 * y + this.m02 * z + this.m03;
            dst[b] = this.m10 * x + this.m11 * y + this.m12 * z + this.m13;
            dst[c] = this.m20 * x + this.m21 * y + this.m22 * z + this.m23;
            a += 3;
        }
    }

    public final void getTranslation(Vec3 translation) {
        translation.load(this.m03, this.m13, this.m23);
    }

    public final void setColumn(int column, Vec4 v) {
        switch (column) {
            case 0: {
                this.m00 = v.x;
                this.m10 = v.y;
                this.m20 = v.z;
                this.m30 = v.w;
                break;
            }
            case 1: {
                this.m01 = v.x;
                this.m11 = v.y;
                this.m21 = v.z;
                this.m31 = v.w;
                break;
            }
            case 2: {
                this.m02 = v.x;
                this.m12 = v.y;
                this.m22 = v.z;
                this.m32 = v.w;
                break;
            }
            case 3: {
                this.m03 = v.x;
                this.m13 = v.y;
                this.m23 = v.z;
                this.m33 = v.w;
            }
        }
    }

    public final void getColumn(int column, Vec4 v) {
        switch (column) {
            case 0: {
                v.x = this.m00;
                v.y = this.m10;
                v.z = this.m20;
                v.w = this.m30;
                break;
            }
            case 1: {
                v.x = this.m01;
                v.y = this.m11;
                v.z = this.m21;
                v.w = this.m31;
                break;
            }
            case 2: {
                v.x = this.m02;
                v.y = this.m12;
                v.z = this.m22;
                v.w = this.m32;
                break;
            }
            case 3: {
                v.x = this.m03;
                v.y = this.m13;
                v.z = this.m23;
                v.w = this.m33;
            }
        }
    }

    public final void setRow(int row, Vec4 v) {
        switch (row) {
            case 0: {
                this.m00 = v.x();
                this.m01 = v.y();
                this.m02 = v.z();
                this.m03 = v.w();
                break;
            }
            case 1: {
                this.m10 = v.x();
                this.m11 = v.y();
                this.m12 = v.z();
                this.m13 = v.w();
                break;
            }
            case 2: {
                this.m20 = v.x();
                this.m21 = v.y();
                this.m22 = v.z();
                this.m23 = v.w();
                break;
            }
            case 3: {
                this.m30 = v.x();
                this.m31 = v.y();
                this.m32 = v.z();
                this.m33 = v.w();
            }
        }
    }

    public final void getRow(int row, Vec4 v) {
        switch (row) {
            case 0: {
                v.x(this.m00);
                v.y(this.m01);
                v.z(this.m02);
                v.w(this.m03);
                break;
            }
            case 1: {
                v.x(this.m10);
                v.y(this.m11);
                v.z(this.m12);
                v.w(this.m13);
                break;
            }
            case 2: {
                v.x(this.m20);
                v.y(this.m21);
                v.z(this.m22);
                v.w(this.m23);
                break;
            }
            case 3: {
                v.x(this.m30);
                v.y(this.m31);
                v.z(this.m32);
                v.w(this.m33);
            }
        }
    }

    public final void get(FloatBuffer dst) {
        int pos = dst.position();
        dst.put(pos + 0, this.m00);
        dst.put(pos + 1, this.m01);
        dst.put(pos + 2, this.m02);
        dst.put(pos + 3, this.m03);
        dst.put(pos + 4, this.m10);
        dst.put(pos + 5, this.m11);
        dst.put(pos + 6, this.m12);
        dst.put(pos + 7, this.m13);
        dst.put(pos + 8, this.m20);
        dst.put(pos + 9, this.m21);
        dst.put(pos + 10, this.m22);
        dst.put(pos + 11, this.m23);
        dst.put(pos + 12, this.m30);
        dst.put(pos + 13, this.m31);
        dst.put(pos + 14, this.m32);
        dst.put(pos + 15, this.m33);
        dst.position(pos + 16);
    }

    public final void get(Matrix4 dst) {
        dst.m00 = this.m00;
        dst.m01 = this.m01;
        dst.m02 = this.m02;
        dst.m03 = this.m03;
        dst.m10 = this.m10;
        dst.m11 = this.m11;
        dst.m12 = this.m12;
        dst.m13 = this.m13;
        dst.m20 = this.m20;
        dst.m21 = this.m21;
        dst.m22 = this.m22;
        dst.m23 = this.m23;
        dst.m30 = this.m30;
        dst.m31 = this.m31;
        dst.m32 = this.m32;
        dst.m33 = this.m33;
    }

    public final void set(Matrix4 src) {
        this.m00 = src.m00;
        this.m01 = src.m01;
        this.m02 = src.m02;
        this.m03 = src.m03;
        this.m10 = src.m10;
        this.m11 = src.m11;
        this.m12 = src.m12;
        this.m13 = src.m13;
        this.m20 = src.m20;
        this.m21 = src.m21;
        this.m22 = src.m22;
        this.m23 = src.m23;
        this.m30 = src.m30;
        this.m31 = src.m31;
        this.m32 = src.m32;
        this.m33 = src.m33;
    }

    public final void set(FloatBuffer src) {
        int pos = src.position();
        this.m00 = src.get(pos + 0);
        this.m01 = src.get(pos + 1);
        this.m02 = src.get(pos + 2);
        this.m03 = src.get(pos + 3);
        this.m10 = src.get(pos + 4);
        this.m11 = src.get(pos + 5);
        this.m12 = src.get(pos + 6);
        this.m13 = src.get(pos + 7);
        this.m20 = src.get(pos + 8);
        this.m21 = src.get(pos + 9);
        this.m22 = src.get(pos + 10);
        this.m23 = src.get(pos + 11);
        this.m30 = src.get(pos + 12);
        this.m31 = src.get(pos + 13);
        this.m32 = src.get(pos + 14);
        this.m33 = src.get(pos + 15);
        src.position(pos + 16);
    }

    public final void getTranspose(FloatBuffer dst) {
        int pos = dst.position();
        dst.put(pos + 0, this.m00);
        dst.put(pos + 1, this.m10);
        dst.put(pos + 2, this.m20);
        dst.put(pos + 3, this.m30);
        dst.put(pos + 4, this.m01);
        dst.put(pos + 5, this.m11);
        dst.put(pos + 6, this.m21);
        dst.put(pos + 7, this.m31);
        dst.put(pos + 8, this.m02);
        dst.put(pos + 9, this.m12);
        dst.put(pos + 10, this.m22);
        dst.put(pos + 11, this.m32);
        dst.put(pos + 12, this.m03);
        dst.put(pos + 13, this.m13);
        dst.put(pos + 14, this.m23);
        dst.put(pos + 15, this.m33);
        dst.position(pos + 16);
    }

    public final void getTranspose(Matrix4 dst) {
        dst.m00 = this.m00;
        dst.m01 = this.m10;
        dst.m02 = this.m20;
        dst.m03 = this.m30;
        dst.m10 = this.m01;
        dst.m11 = this.m11;
        dst.m12 = this.m21;
        dst.m13 = this.m31;
        dst.m20 = this.m02;
        dst.m21 = this.m12;
        dst.m22 = this.m22;
        dst.m23 = this.m32;
        dst.m30 = this.m03;
        dst.m31 = this.m13;
        dst.m32 = this.m23;
        dst.m33 = this.m33;
    }

    public final void setTranspose(Matrix4 src) {
        this.m00 = src.m00;
        this.m01 = src.m10;
        this.m02 = src.m20;
        this.m03 = src.m30;
        this.m10 = src.m01;
        this.m11 = src.m11;
        this.m12 = src.m21;
        this.m13 = src.m31;
        this.m20 = src.m02;
        this.m21 = src.m12;
        this.m22 = src.m22;
        this.m23 = src.m32;
        this.m30 = src.m03;
        this.m31 = src.m13;
        this.m32 = src.m23;
        this.m33 = src.m33;
    }

    public final void setTranspose(FloatBuffer src) {
        int pos = src.position();
        this.m00 = src.get(pos + 0);
        this.m10 = src.get(pos + 1);
        this.m20 = src.get(pos + 2);
        this.m30 = src.get(pos + 3);
        this.m01 = src.get(pos + 4);
        this.m11 = src.get(pos + 5);
        this.m21 = src.get(pos + 6);
        this.m31 = src.get(pos + 7);
        this.m02 = src.get(pos + 8);
        this.m12 = src.get(pos + 9);
        this.m22 = src.get(pos + 10);
        this.m32 = src.get(pos + 11);
        this.m03 = src.get(pos + 12);
        this.m13 = src.get(pos + 13);
        this.m23 = src.get(pos + 14);
        this.m33 = src.get(pos + 15);
        src.position(pos + 16);
    }

    public final void identity() {
        this.m03 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m13 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m23 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        this.m33 = 1.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
    }

    public final void transpose() {
        float t01 = this.m10;
        float t02 = this.m20;
        float t03 = this.m30;
        float t10 = this.m01;
        float t12 = this.m21;
        float t13 = this.m31;
        float t20 = this.m02;
        float t21 = this.m12;
        float t23 = this.m32;
        float t30 = this.m03;
        float t31 = this.m13;
        float t32 = this.m23;
        this.m01 = t01;
        this.m02 = t02;
        this.m03 = t03;
        this.m10 = t10;
        this.m12 = t12;
        this.m13 = t13;
        this.m20 = t20;
        this.m21 = t21;
        this.m23 = t23;
        this.m30 = t30;
        this.m31 = t31;
        this.m32 = t32;
    }

    public final void invert() {
        float determinant = this.determinant();
        if (determinant == 0.0f) {
            return;
        }
        float t00 = this.determinant3x3(this.m11, this.m12, this.m13, this.m21, this.m22, this.m23, this.m31, this.m32, this.m33);
        float t01 = -this.determinant3x3(this.m10, this.m12, this.m13, this.m20, this.m22, this.m23, this.m30, this.m32, this.m33);
        float t02 = this.determinant3x3(this.m10, this.m11, this.m13, this.m20, this.m21, this.m23, this.m30, this.m31, this.m33);
        float t03 = -this.determinant3x3(this.m10, this.m11, this.m12, this.m20, this.m21, this.m22, this.m30, this.m31, this.m32);
        float t10 = -this.determinant3x3(this.m01, this.m02, this.m03, this.m21, this.m22, this.m23, this.m31, this.m32, this.m33);
        float t11 = this.determinant3x3(this.m00, this.m02, this.m03, this.m20, this.m22, this.m23, this.m30, this.m32, this.m33);
        float t12 = -this.determinant3x3(this.m00, this.m01, this.m03, this.m20, this.m21, this.m23, this.m30, this.m31, this.m33);
        float t13 = this.determinant3x3(this.m00, this.m01, this.m02, this.m20, this.m21, this.m22, this.m30, this.m31, this.m32);
        float t20 = this.determinant3x3(this.m01, this.m02, this.m03, this.m11, this.m12, this.m13, this.m31, this.m32, this.m33);
        float t21 = -this.determinant3x3(this.m00, this.m02, this.m03, this.m10, this.m12, this.m13, this.m30, this.m32, this.m33);
        float t22 = this.determinant3x3(this.m00, this.m01, this.m03, this.m10, this.m11, this.m13, this.m30, this.m31, this.m33);
        float t23 = -this.determinant3x3(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m30, this.m31, this.m32);
        float t30 = -this.determinant3x3(this.m01, this.m02, this.m03, this.m11, this.m12, this.m13, this.m21, this.m22, this.m23);
        float t31 = this.determinant3x3(this.m00, this.m02, this.m03, this.m10, this.m12, this.m13, this.m20, this.m22, this.m23);
        float t32 = -this.determinant3x3(this.m00, this.m01, this.m03, this.m10, this.m11, this.m13, this.m20, this.m21, this.m23);
        float t33 = this.determinant3x3(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
        float invDeterminant = 1.0f / determinant;
        this.m00 = t00 * invDeterminant;
        this.m01 = t10 * invDeterminant;
        this.m02 = t20 * invDeterminant;
        this.m03 = t30 * invDeterminant;
        this.m10 = t01 * invDeterminant;
        this.m11 = t11 * invDeterminant;
        this.m12 = t21 * invDeterminant;
        this.m13 = t31 * invDeterminant;
        this.m20 = t02 * invDeterminant;
        this.m21 = t12 * invDeterminant;
        this.m22 = t22 * invDeterminant;
        this.m23 = t32 * invDeterminant;
        this.m30 = t03 * invDeterminant;
        this.m31 = t13 * invDeterminant;
        this.m32 = t23 * invDeterminant;
        this.m33 = t33 * invDeterminant;
    }

    private final float determinant() {
        float f = 0.0f;
        f += this.m00 * (this.m11 * this.m22 * this.m33 + this.m12 * this.m23 * this.m31 + this.m13 * this.m21 * this.m32 - (this.m13 * this.m22 * this.m31 + this.m11 * this.m23 * this.m32 + this.m12 * this.m21 * this.m33));
        f -= this.m01 * (this.m10 * this.m22 * this.m33 + this.m12 * this.m23 * this.m30 + this.m13 * this.m20 * this.m32 - (this.m13 * this.m22 * this.m30 + this.m10 * this.m23 * this.m32 + this.m12 * this.m20 * this.m33));
        f += this.m02 * (this.m10 * this.m21 * this.m33 + this.m11 * this.m23 * this.m30 + this.m13 * this.m20 * this.m31 - (this.m13 * this.m21 * this.m30 + this.m10 * this.m23 * this.m31 + this.m11 * this.m20 * this.m33));
        return f -= this.m03 * (this.m10 * this.m21 * this.m32 + this.m11 * this.m22 * this.m30 + this.m12 * this.m20 * this.m31 - (this.m12 * this.m21 * this.m30 + this.m10 * this.m22 * this.m31 + this.m11 * this.m20 * this.m32));
    }

    private final float determinant3x3(float t00, float t01, float t02, float t10, float t11, float t12, float t20, float t21, float t22) {
        return t00 * (t11 * t22 - t12 * t21) + t01 * (t12 * t20 - t10 * t22) + t02 * (t10 * t21 - t11 * t20);
    }

    public final void scale(Vec3 v) {
        this.scale(v.x, v.y, v.z);
    }

    public final void scale(float x, float y, float z) {
        this.m00 *= x;
        this.m10 *= x;
        this.m20 *= x;
        this.m30 *= x;
        this.m01 *= y;
        this.m11 *= y;
        this.m21 *= y;
        this.m31 *= y;
        this.m02 *= z;
        this.m12 *= z;
        this.m22 *= z;
        this.m32 *= z;
    }

    public final void scaleX(float s) {
        this.m00 *= s;
        this.m10 *= s;
        this.m20 *= s;
        this.m30 *= s;
    }

    public final void scaleY(float s) {
        this.m01 *= s;
        this.m11 *= s;
        this.m21 *= s;
        this.m31 *= s;
    }

    public final void scaleZ(float s) {
        this.m02 *= s;
        this.m12 *= s;
        this.m22 *= s;
        this.m32 *= s;
    }

    public final void scale(float d) {
        this.m00 *= d;
        this.m10 *= d;
        this.m20 *= d;
        this.m30 *= d;
        this.m01 *= d;
        this.m11 *= d;
        this.m21 *= d;
        this.m31 *= d;
        this.m02 *= d;
        this.m12 *= d;
        this.m22 *= d;
        this.m32 *= d;
    }

    public final void translate(Vec3 v) {
        this.translate(v.x(), v.y(), v.z());
    }

    public final void translate(float x, float y, float z) {
        this.m03 += this.m00 * x + this.m01 * y + this.m02 * z;
        this.m13 += this.m10 * x + this.m11 * y + this.m12 * z;
        this.m23 += this.m20 * x + this.m21 * y + this.m22 * z;
        this.m33 += this.m30 * x + this.m31 * y + this.m32 * z;
    }

    public final void translateX(float t) {
        this.m03 += this.m00 * t;
        this.m13 += this.m10 * t;
        this.m23 += this.m20 * t;
        this.m33 += this.m30 * t;
    }

    public final void translateY(float t) {
        this.m03 += this.m01 * t;
        this.m13 += this.m11 * t;
        this.m23 += this.m21 * t;
        this.m33 += this.m31 * t;
    }

    public final void translateZ(float t) {
        this.m03 += this.m02 * t;
        this.m13 += this.m12 * t;
        this.m23 += this.m22 * t;
        this.m33 += this.m32 * t;
    }

    public final void rotX(float a) {
        float d11 = FastMath.cosDeg(a);
        float d21 = FastMath.sinDeg(a);
        float d12 = -d21;
        float d22 = d11;
        float t01 = this.m01 * d11 + this.m02 * d21;
        this.m02 = this.m01 * d12 + this.m02 * d22;
        float t11 = this.m11 * d11 + this.m12 * d21;
        this.m12 = this.m11 * d12 + this.m12 * d22;
        float t21 = this.m21 * d11 + this.m22 * d21;
        this.m22 = this.m21 * d12 + this.m22 * d22;
        float t31 = this.m31 * d11 + this.m32 * d21;
        this.m32 = this.m31 * d12 + this.m32 * d22;
        this.m01 = t01;
        this.m11 = t11;
        this.m21 = t21;
        this.m31 = t31;
    }

    public final void rotY(float a) {
        a = -a;
        float d00 = FastMath.cosDeg(a);
        float d20 = FastMath.sinDeg(a);
        float d02 = -d20;
        float d22 = d00;
        float t00 = this.m00 * d00 + this.m02 * d20;
        this.m02 = this.m00 * d02 + this.m02 * d22;
        float t10 = this.m10 * d00 + this.m12 * d20;
        this.m12 = this.m10 * d02 + this.m12 * d22;
        float t20 = this.m20 * d00 + this.m22 * d20;
        this.m22 = this.m20 * d02 + this.m22 * d22;
        float t30 = this.m30 * d00 + this.m32 * d20;
        this.m32 = this.m30 * d02 + this.m32 * d22;
        this.m00 = t00;
        this.m10 = t10;
        this.m20 = t20;
        this.m30 = t30;
    }

    public final void rotZ(float a) {
        float d00 = FastMath.cosDeg(a);
        float d10 = FastMath.sinDeg(a);
        float d01 = -d10;
        float d11 = d00;
        float t00 = this.m00 * d00 + this.m01 * d10;
        this.m01 = this.m00 * d01 + this.m01 * d11;
        float t10 = this.m10 * d00 + this.m11 * d10;
        this.m11 = this.m10 * d01 + this.m11 * d11;
        float t20 = this.m20 * d00 + this.m21 * d10;
        this.m21 = this.m20 * d01 + this.m21 * d11;
        float t30 = this.m30 * d00 + this.m31 * d10;
        this.m31 = this.m30 * d01 + this.m31 * d11;
        this.m00 = t00;
        this.m10 = t10;
        this.m20 = t20;
        this.m30 = t30;
    }

    public final void rotate(Vec3 rot) {
        this.rotate(rot.x, rot.y, rot.z);
    }

    public final void rotate(float x, float y, float z) {
        y = -y;
        float cx = FastMath.cosDeg(x);
        float sx = FastMath.sinDeg(x);
        float cy = FastMath.cosDeg(y);
        float sy = FastMath.sinDeg(y);
        float cz = FastMath.cosDeg(z);
        float sz = FastMath.sinDeg(z);
        float cxsy = cx * sy;
        float sxsy = sx * sy;
        float d00 = cy * cz;
        float d01 = -cy * sz;
        float d02 = -sy;
        float d10 = -sxsy * cz + cx * sz;
        float d11 = sxsy * sz + cx * cz;
        float d12 = -sx * cy;
        float d20 = cxsy * cz + sx * sz;
        float d21 = -cxsy * sz + sx * cz;
        float d22 = cx * cy;
        float t00 = this.m00 * d00 + this.m01 * d10 + this.m02 * d20;
        float t01 = this.m00 * d01 + this.m01 * d11 + this.m02 * d21;
        float t02 = this.m00 * d02 + this.m01 * d12 + this.m02 * d22;
        float t10 = this.m10 * d00 + this.m11 * d10 + this.m12 * d20;
        float t11 = this.m10 * d01 + this.m11 * d11 + this.m12 * d21;
        float t12 = this.m10 * d02 + this.m11 * d12 + this.m12 * d22;
        float t20 = this.m20 * d00 + this.m21 * d10 + this.m22 * d20;
        float t21 = this.m20 * d01 + this.m21 * d11 + this.m22 * d21;
        float t22 = this.m20 * d02 + this.m21 * d12 + this.m22 * d22;
        float t30 = this.m30 * d00 + this.m31 * d10 + this.m32 * d20;
        float t31 = this.m30 * d01 + this.m31 * d11 + this.m32 * d21;
        float t32 = this.m30 * d02 + this.m31 * d12 + this.m32 * d22;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
        this.m30 = t30;
        this.m31 = t31;
        this.m32 = t32;
    }

    public final void mult(Matrix4 m) {
        float t00 = this.m00 * m.m00 + this.m01 * m.m10 + this.m02 * m.m20 + this.m03 * m.m30;
        float t01 = this.m00 * m.m01 + this.m01 * m.m11 + this.m02 * m.m21 + this.m03 * m.m31;
        float t02 = this.m00 * m.m02 + this.m01 * m.m12 + this.m02 * m.m22 + this.m03 * m.m32;
        float t03 = this.m00 * m.m03 + this.m01 * m.m13 + this.m02 * m.m23 + this.m03 * m.m33;
        float t10 = this.m10 * m.m00 + this.m11 * m.m10 + this.m12 * m.m20 + this.m13 * m.m30;
        float t11 = this.m10 * m.m01 + this.m11 * m.m11 + this.m12 * m.m21 + this.m13 * m.m31;
        float t12 = this.m10 * m.m02 + this.m11 * m.m12 + this.m12 * m.m22 + this.m13 * m.m32;
        float t13 = this.m10 * m.m03 + this.m11 * m.m13 + this.m12 * m.m23 + this.m13 * m.m33;
        float t20 = this.m20 * m.m00 + this.m21 * m.m10 + this.m22 * m.m20 + this.m23 * m.m30;
        float t21 = this.m20 * m.m01 + this.m21 * m.m11 + this.m22 * m.m21 + this.m23 * m.m31;
        float t22 = this.m20 * m.m02 + this.m21 * m.m12 + this.m22 * m.m22 + this.m23 * m.m32;
        float t23 = this.m20 * m.m03 + this.m21 * m.m13 + this.m22 * m.m23 + this.m23 * m.m33;
        float t30 = this.m30 * m.m00 + this.m31 * m.m10 + this.m32 * m.m20 + this.m33 * m.m30;
        float t31 = this.m30 * m.m01 + this.m31 * m.m11 + this.m32 * m.m21 + this.m33 * m.m31;
        float t32 = this.m30 * m.m02 + this.m31 * m.m12 + this.m32 * m.m22 + this.m33 * m.m32;
        float t33 = this.m30 * m.m03 + this.m31 * m.m13 + this.m32 * m.m23 + this.m33 * m.m33;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m03 = t03;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m13 = t13;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
        this.m23 = t23;
        this.m30 = t30;
        this.m31 = t31;
        this.m32 = t32;
        this.m33 = t33;
    }

    public final boolean equals(Matrix4 mat, float margin) {
        if (!(EasyMath.equals(this.m00, mat.m00, margin) && EasyMath.equals(this.m10, mat.m10, margin) && EasyMath.equals(this.m20, mat.m20, margin) && EasyMath.equals(this.m30, mat.m30, margin))) {
            return false;
        }
        if (!(EasyMath.equals(this.m01, mat.m01, margin) && EasyMath.equals(this.m11, mat.m11, margin) && EasyMath.equals(this.m21, mat.m21, margin) && EasyMath.equals(this.m31, mat.m31, margin))) {
            return false;
        }
        if (!(EasyMath.equals(this.m02, mat.m02, margin) && EasyMath.equals(this.m12, mat.m12, margin) && EasyMath.equals(this.m22, mat.m22, margin) && EasyMath.equals(this.m32, mat.m32, margin))) {
            return false;
        }
        return EasyMath.equals(this.m03, mat.m03, margin) && EasyMath.equals(this.m13, mat.m13, margin) && EasyMath.equals(this.m23, mat.m23, margin) && EasyMath.equals(this.m33, mat.m33, margin);
    }

    public final float cumulativeDiff(Matrix4 m) {
        float sum = 0.0f;
        sum += Math.abs(this.m00 - m.m00);
        sum += Math.abs(this.m01 - m.m01);
        sum += Math.abs(this.m02 - m.m02);
        sum += Math.abs(this.m03 - m.m03);
        sum += Math.abs(this.m10 - m.m10);
        sum += Math.abs(this.m11 - m.m11);
        sum += Math.abs(this.m12 - m.m12);
        sum += Math.abs(this.m13 - m.m13);
        sum += Math.abs(this.m20 - m.m20);
        sum += Math.abs(this.m21 - m.m21);
        sum += Math.abs(this.m22 - m.m22);
        sum += Math.abs(this.m23 - m.m23);
        sum += Math.abs(this.m30 - m.m30);
        sum += Math.abs(this.m31 - m.m31);
        sum += Math.abs(this.m32 - m.m32);
        return sum += Math.abs(this.m33 - m.m33);
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        String sep = "  ";
        buffer.append("Matrix4[ ");
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m00, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m01, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m02, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m03, (int)3, (int)3)) + "\n");
        buffer.append("         ");
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m10, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m11, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m12, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m13, (int)3, (int)3)) + "\n");
        buffer.append("         ");
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m20, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m21, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m22, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m23, (int)3, (int)3)) + "\n");
        buffer.append("         ");
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m30, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m31, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m32, (int)3, (int)3)) + sep);
        buffer.append(String.valueOf(TextValues.formatNumber((double)this.m33, (int)3, (int)3)) + " ]");
        return buffer.toString();
    }
}

