/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.math;

import craterstudio.math.FastMath;
import java.util.Random;

public class EasyMath {
    public static final int NO_TRANSFORM = 0;
    public static final int SQUARED_TRANSFORM = 1;
    public static final int INVERSE_SQUARED_TRANSFORM = 2;
    public static final int SMOOTH_TRANSFORM = 3;
    public static final int SQUARED_SMOOTH_TRANSFORM = 4;
    public static final int INVERSE_SQUARED_SMOOTH_TRANSFORM = 5;

    public static final float transform(float percent, int type) {
        if (type == 0) {
            return percent;
        }
        if (type == 1) {
            return percent * percent;
        }
        if (type == 2 || type == 5) {
            percent = 1.0f - percent;
        }
        if (type == 2) {
            return 1.0f - percent * percent;
        }
        percent = (FastMath.sinDegStrict(percent * 180.0f - 90.0f) + 1.0f) * 0.5f;
        if (type == 3) {
            return percent;
        }
        if (type == 4) {
            return percent * percent;
        }
        if (type == 5) {
            return 1.0f - percent * percent;
        }
        return -1.0f;
    }

    public static final float gradients(float cur, float[] keys, float[] values) {
        int src = keys.length - 1;
        int dst = keys.length - 1;
        int i = 1;
        while (i < keys.length) {
            if (cur < keys[i]) {
                src = i - 1;
                dst = i - 0;
                return EasyMath.interpolate(cur, keys[src], keys[dst], values[src], values[dst]);
            }
            ++i;
        }
        return -1.0f;
    }

    public static final boolean isPowerOfTwo(int n) {
        int i = 0;
        while (i < 31) {
            if (n == 1 << i) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final int fitInPowerOfTwo(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        int i = 1;
        while (i < 31) {
            int pow = 1 << i;
            if (n <= pow) {
                return pow;
            }
            ++i;
        }
        return -1;
    }

    public static final int widthInBits(int n) {
        if (n < 0) {
            return 32;
        }
        int i = 30;
        while (i >= 0) {
            if (n >= 1 << i) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public static final float curve(float distance, float topDistance, float margin, float power) {
        float percent = EasyMath.invLerp(distance, topDistance - margin, topDistance);
        float angle = percent * 90.0f;
        if (angle < 0.0f || angle > 180.0f) {
            return 0.0f;
        }
        float sinCurve = FastMath.sinDeg(angle);
        return (float)Math.pow(sinCurve, power);
    }

    public static final float lerp(float t, float a, float b) {
        return a + t * (b - a);
    }

    public static final float lerpWithCap(float cur, float min, float max) {
        if (cur < 0.0f) {
            return min;
        }
        if (cur > 1.0f) {
            return max;
        }
        return (cur - min) / (max - min);
    }

    public static final float invLerp(float cur, float min, float max) {
        return (cur - min) / (max - min);
    }

    public static final float invLerpWithCap(float cur, float min, float max) {
        if (cur < min) {
            return 0.0f;
        }
        if (cur > max) {
            return 1.0f;
        }
        return EasyMath.invLerp(cur, min, max);
    }

    public static final float invLerp(long cur, long min, long max) {
        return (float)(cur - min) / (float)(max - min);
    }

    public static final float invLerpWithCap(long cur, long min, long max) {
        if (cur < min) {
            return 0.0f;
        }
        if (cur > max) {
            return 1.0f;
        }
        return EasyMath.invLerp(cur, min, max);
    }

    public static final float interpolate(float cur, float min, float max, float startValue, float endValue) {
        return EasyMath.lerp(EasyMath.invLerp(cur, min, max), startValue, endValue);
    }

    public static final float interpolate(float cur, float min, float max, float startValue, float endValue, int transform) {
        return EasyMath.lerp(EasyMath.transform(EasyMath.invLerp(cur, min, max), transform), startValue, endValue);
    }

    public static final float interpolateWithCap(float cur, float min, float max, float startValue, float endValue) {
        if (cur < min) {
            return startValue;
        }
        if (cur > max) {
            return endValue;
        }
        return EasyMath.lerp(EasyMath.invLerp(cur, min, max), startValue, endValue);
    }

    public static final float interpolate2d(float x, float z, float nw, float ne, float se, float sw) {
        if ((x -= (float)((int)x)) > (z -= (float)((int)z))) {
            sw = nw + se - ne;
        } else {
            ne = se + nw - sw;
        }
        float n = EasyMath.lerp(x, nw, ne);
        float s = EasyMath.lerp(x, sw, se);
        return EasyMath.lerp(z, n, s);
    }

    public static final double clamp(double val, double min, double max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static final float clamp(float val, float min, float max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static final long clamp(long val, long min, long max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static final int clamp(int val, int min, int max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static final boolean isBetween(double val, double min, double max) {
        return min <= val && val <= max;
    }

    public static final boolean isBetween(float val, float min, float max) {
        return min <= val && val <= max;
    }

    public static final boolean isBetween(long val, long min, long max) {
        return min <= val && val <= max;
    }

    public static final boolean isBetween(int val, int min, int max) {
        return min <= val && val <= max;
    }

    public static final boolean areBetween(int[] val, int min, int max) {
        int i = 0;
        while (i < val.length) {
            if (min > val[i] || val[i] > max) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equals(float a, float b, float error) {
        if (a == b) {
            return true;
        }
        float diff = a - b;
        return diff * diff < error * error;
    }

    public static final float mirror(float val, float edge, boolean up) {
        if (up && val > edge || !up && val < edge) {
            return edge * 2.0f - val;
        }
        return val;
    }

    public static final float bounce(float val, float down, float up) {
        if (down >= up) {
            return val;
        }
        while (true) {
            if (val > up) {
                val = up * 2.0f - val;
                continue;
            }
            if (!(val < down)) break;
            val = down * 2.0f - val;
        }
        return val;
    }

    public static final float moduloAbs(float val, float max) {
        return (val % max + max) % max;
    }

    public static final int moduloAbs(int val, int max) {
        return (val % max + max) % max;
    }

    public static final long moduloAbs(long val, long max) {
        return (val % max + max) % max;
    }

    public static final float moduloInRange(float val, float min, float max) {
        float range = max - min;
        float adjust = (val - min) % range;
        if (adjust >= 0.0f) {
            return adjust + min;
        }
        return adjust + min + range;
    }

    public static final int moduloInRange(int val, int min, int max) {
        int range = max - min;
        int adjust = (val - min) % range;
        if (adjust >= 0) {
            return adjust + min;
        }
        return adjust + min + range;
    }

    public static final long moduloInRange(long val, long min, long max) {
        long range = max - min;
        long adjust = (val - min) % range;
        if (adjust >= 0L) {
            return adjust + min;
        }
        return adjust + min + range;
    }

    public static final float random(Random r) {
        return (r.nextFloat() - 0.5f) * 2.0f;
    }

    public static final float random(Random r, float max) {
        return r.nextFloat() * max;
    }

    public static final float random(Random r, float min, float max) {
        return r.nextFloat() * (max - min) + min;
    }

    public static final float randomRange(Random r, float base, float range) {
        return base + EasyMath.random(r) * range;
    }

    public static boolean intersects(int aMin, int aMax, int bMin, int bMax) {
        if (EasyMath.isBetween(aMin, bMin, bMax)) {
            return true;
        }
        if (EasyMath.isBetween(aMax, bMin, bMax)) {
            return true;
        }
        if (EasyMath.isBetween(bMin, aMin, aMax)) {
            return true;
        }
        return EasyMath.isBetween(bMax, aMin, aMax);
    }

    public static boolean intersects(int[] min, int[] max, int[] off, int dim) {
        int i = 0;
        while (i < min.length) {
            if (!EasyMath.intersects(off[i], off[i] + dim, min[i], max[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

